/* $Id: ctype.h,v 1.2 1994/10/10 18:44:52 stuart Exp $ */

/* The <ctype.h> header file defines some macros used to identify characters.
 * It works by using a table stored in ctype.c.  When a character is presented
 * to one of these macros, the character is used as an index into the table
 * (__ctype_locale) to retrieve a byte.  The relevant bit is then extracted.
 */

#ifndef _CTYPE_H
#define _CTYPE_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _MINIX_LOCALE_H
#include <minix/locale.h>
#endif

extern unsigned char __tmp;	/* scratch variable */

#define _U		0001	/* this bit is for upper-case letters [A-Z] */
#define _L		0002	/* this bit is for lower-case letters [a-z] */
#define _N		0004	/* this bit is for numbers [0-9] */
#define _S		0010	/* this bit is for white space \t \n \f etc */
#define _P		0020	/* this bit is for punctuation characters */
#define _C		0040	/* this bit is for control characters */
#define _X		0100	/* this bit is for hex digits [a-f] and [A-F]*/
#define _SP		0200	/* this bit is for the space character only */

int isalnum(int  __c);	/* alphanumeric [a-z], [A-Z], [0-9] */
int isalpha(int  __c);	/* alphabetic */
int iscntrl(int  __c);	/* control characters */
int isdigit(int  __c);	/* digit [0-9] */
int isgraph(int  __c);	/* graphic character */
int islower(int  __c);	/* lower-case letter [a-z] */
int isprint(int  __c);	/* printable character */
int ispunct(int  __c);	/* punctuation mark */
int isspace(int  __c);	/* white space sp, \f, \n, \r, \t, \v*/
int isupper(int  __c);	/* upper-case letter [A-Z] */
int isxdigit(int  __c);	/* hex digit [0-9], [a-f], [A-F] */

/* Macros for identifying character classes. */
#define isalnum(c)	((__ctype_locale)[c]&(_U|_L|_N))
#define isalpha(c)	((__ctype_locale)[c]&(_U|_L))
#define iscntrl(c)	((__ctype_locale)[c]&_C)
#define isdigit(c)	((__ctype_locale)[c]&_N)
#define isgraph(c)	((__ctype_locale)[c]&(_P|_U|_L|_N))
#define islower(c)	((__ctype_locale)[c]&_L)
#define isprint(c)	((__ctype_locale)[c]&(_SP|_P|_U|_L|_N))
#define ispunct(c)	((__ctype_locale)[c]&_P)
#define isspace(c)	((__ctype_locale)[c]&_S)
#define isupper(c)	((__ctype_locale)[c]&_U)
#define isxdigit(c)	((__ctype_locale)[c]&(_N|_X))
#define isascii(c)	((unsigned) ((c) + 1) < 129)

/* The following two macros are weird to keep the Language Police at bay.
 * The macro 'tolower' only affects upper case letters, and 'toupper'
 * only affects lower case letters.  Neither one is permitted to evaluate
 * its argument more than once.  Thus a simple definition like:
 *
 *	#define tolower(c)	(isupper(c) ? c - 'A' + 'a' : c)
 *
 * is prohibited because the argument 'c' is evaluated twice.
 * It might be an expression that has side effects, such as a function
 * call that increments a counter and returns its value as a character.
 * The solution is to first copy the argument to a scratch variable, __tmp.
 */

#define tolower(c) (__tmp = (c), isupper(__tmp) ? __tmp - 'A' + 'a' : __tmp)
#define toupper(c) (__tmp = (c), islower(__tmp) ? __tmp - 'a' + 'A' : __tmp)

#ifdef __cplusplus
}
#endif

#endif
