/*
 * $Source: /usr/l/src/local/bin/xterm-wrapper/RCS/xterm-wrapper.c,v $
 *
 * Main body of wrapper program to allow OPS and other programs to
 * run under X.
 *
 * This code is copyright      The University of Kent (UKC)
 *                    and      Tony Curtis
 *                             1991
 *
 * If you change or use this file for your own purposes
 * please make sure this copyright notice is retained.
 *
 * Copyright (C) 1993 David Beckett, University of Kent at Canterbury
 *
 */

#ifndef lint
static char rcsid[] = "$Id: xterm-wrapper.c,v 1.9 1994/11/24 11:17:38 djb1 Exp $";
#endif /* lint */

/*
 * run an xterm with the folding editor (or whatever) in it.
 * Need to do this because of the key mappings of different keyboards
 * under X11.  We provide a defaults file which has various keyboard maps
 * in it : /usr/l/lib/xterm-wrapper/xterm-wrapper.def
 * (XTERM_WRAPPER_RESOURCES_PATH)
 * This is merged in using xrdb in 'cmd.c'
 *
 * We assume that host entries can map to host types in some way
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/param.h>
#include <ctype.h>
#include <pwd.h>

#include "libdjb.h"

#include "mach.h"		/* machine type */
#include "version.h"		/* current version */
#include "cmd.h"

/* command to pull up man page as help */
#define MAN "man"

static char *dpy;		/* X display */

int main PROTO((int argc, char *argv[]));
static void showHelp PROTO((void));
  
static const char *XWrap_Name= WRAP_NAME;
static const char *XTrun_Name = "xtrun"; 
static const char *Trun_Name = "trun";
static const char *Ops_Name = "ops";

int
main (argc, argv)
     int argc;
     char *argv[];
{
  char hostname[16];		/* this machine */
  char *userprog;		/* code to actually run */
  char *term;			/* terminal type */
  char scrn[MAXPATHLEN];	/* screen user sat at */
  struct m_info *machinfo;	/* machine details */
  int dofork;			/* run in background? */
  int ch;			/* option parser */
  int interact;			/* ask for resource menu */
  char *machtype;		/* specifies display type */
  int isops;                    /* Are we 'xops' - be backwards compatible */
  int istrun;                   /* Are we 'xtrun' - give some warnings */  
  int isxwrap;                  /* Are we 'xwrap' - wrap the given program */  
  int optind;
  char *default_machinetype;
  
  /* how program called */
  program_name = strdup(basename (argv[0]));
  
  errf_set_progname(program_name);
  
  isops=!strcmp(program_name+1, Ops_Name);
  istrun=!strcmp(program_name, XTrun_Name);
  isxwrap=!strcmp(program_name, XWrap_Name);

  /* machine name */
  gethostname (hostname, sizeof hostname);

  /* see what display we're on (if at all). */
  dpy = getenv ("DISPLAY");
  if (dpy == NULL)
    dpy = findDisplay (scrn, sizeof scrn);

  /* run in foreground by default */
  dofork = 0;
  /* non-interactive menu */
  interact = 0;

  /* init env */
  machtype = NULL;

  /* any options?  want help? Need help? :-) */
  for(optind = 1; optind<argc && *argv[optind]=='-'; optind++)
    {
      ch=argv[optind][1];
      switch (ch)
	{
	case '-':
	  goto breakout;
	case 'h':		/* give help */
	  showHelp ();
	  /*NOTREACHED*/
	  break;
	case 'b':		/* run in background */
	  ++dofork;
	  break;
	case 'v':		/* verbose */
#ifndef __TIME__
#define __TIME__ "(Unknown time)"
#endif
#ifndef __DATE__
#define __DATE__ "(Unknown date)"
#endif
	  printf ("%s: Version %s of %s %s\n%s\n",
		  program_name, version, __TIME__, __DATE__, 
		  copyright);
	  exit (0);
	  break;
	case 'm':		/* machine keyboard type */
	  optind++;
	  if(optind==argc)
	    {
	      errf("Missing argument to -m");
	      exit(0);
	    }
	  machtype = strdup(argv[optind]);
	  break;
      case 'a':
	++interact;
	break;
      default:			/* pass on to program */
	  goto breakout;
	}
    }
  
 breakout:
  
  /* no more options, default user code */
  if (optind == argc)
    {
      if(isops)
	{
	  char *xc = getenv ("XOPSCODE");
	  userprog = (xc == NULL) ? (char*)Ops_Name : xc;
	}
      else
	/* exec() just the name of the program, without the x */
	userprog = strdup(basename(argv[0])+1);
    }
  else
    /* Thaar be arguments! */
    {
      char *temp;
      char *newname;
      int argisops;
      int argistrun;
      
      newname = NULL;
      
      /* For 'xops' and 'trun', ignore any extra 'ops' or 'trun'
       * command found after the main arguments
       */
      argisops  = !strcmp(argv[optind], Ops_Name);
      argistrun = !strcmp(argv[optind], Trun_Name);
      
      /* Ignore 'xops ops' and 'xtrun trun' */
      if ((isops && argisops) || (istrun && argistrun))
	{
	  errf("Extra %s ignored - %s assumes %s automatically",
	       argv[optind], program_name, argv[optind]);
	  optind++;
	}
      
      /* Warn confused users who do 'xops trun' to use 'xtrun' */
      if (isops && argistrun && optind < argc)
	{
	  char *line;
	  
	  optind++;
	  line = join_vectors(argv, optind);
	  errf("Assuming you meant %s %s",
	       XTrun_Name, line);
	  free(line);
	  newname = strdup(Trun_Name);
	}

      /* For 'xops' - if the first thing found doesn't look like
       * either an option to 'ops' or a number (for processor count)
       * then assume it is a program to run.  Warn the user that
       * there is a real program for this - xwrap and make that
       * the current program.
       */
      if (isops && optind < argc && !strchr("-0123456789", *argv[optind]))
	{
	  errf("Assuming you meant %s %s",
	       XWrap_Name, argv[optind]);
	  newname = strdup(argv[optind]);
	  optind++;
	}
      
      /* If we are the real wrapper program, run the first
       * real argument as the program.
       */
      if (isxwrap && optind < argc)
	{
	  newname = strdup(argv[optind]);
	  optind++;
	}
      
      /* Delete the 'x' from our name and add arguments */
      temp = join_vectors(argv, optind);
      
      /* If we haven't chosen the program to run yet,
       * use the stub of this program's name
       */
      if (!newname)
	newname = strdup(basename(argv[0])+1);
      
      userprog = (char*) malloc(strlen(newname)+strlen(temp));
      
      sprintf(userprog,"%s %s", newname,temp);
      
      free(temp);
      free(newname);
    }
  
#ifdef DEBUG
  errf("userprog is %s", userprog);
#endif
      
  /* suss xterm or ordinary terminal */
  term = getenv ("TERM");
  if (strncmp (term, "xterm", 5) != 0 || dpy == NULL)
    {
      errf ("Not an xterm, just running `%s'", userprog);
      exit (system (userprog));
    }

  /* poke around to find out what terminal type we want */
  machinfo = (machtype != NULL) ? searchMachines (machtype) : machDetails (dpy);
  if (machinfo)
    default_machinetype=strdup(machinfo->m_machinetype);
  else
    default_machinetype=NULL;
  if (interact)
    machinfo = holdHands (default_machinetype);
  if (default_machinetype)
    free(default_machinetype);
  
  if (machinfo == NULL)
    {
      if (machtype != NULL)
	errf ("I don't know machine type `%s'.", machtype);
      else
	{
	  errf ("I can't find a terminal type for display `%s'.", dpy);
	  errf ("See the manual page about the `-i' and `-m' options");
	  exit(1);
	}
    }

  /* show HELP key for this template */

  /* fork off if required */
  if (dofork)
    {
      int pid = fork ();
      if (pid == -1)
	{
	  errf ("unable to fork");
	  exit (1);
	}
      else if (pid > 0)
	exit (0);
    }
  
  mkwindow (machinfo, userprog); /* Never returns */
  
  return(0); /* Keep GCC happy */
}

/*
 * give help
 */
static
void
showHelp ()
{
  execlp (MAN, MAN, program_name, NULL);
  errf ("couldn't show help");
  exit (1);
}
