/*
 * $Source: /usr/l/src/local/bin/xterm-wrapper/RCS/mach.h,v $
 *
 * Machine types header file
 *
 * This code is copyright      The University of Kent (UKC)
 *                    and      Tony Curtis
 *                             1991
 *
 * If you change or use this file for your own purposes
 * please make sure this copyright notice is retained.
 *
 * Copyright (C) 1993 David Beckett, University of Kent at Canterbury
 *
 * $Id: mach.h,v 1.3 1994/11/24 11:20:47 djb1 Exp $
 *
 */

#ifndef _dispmap_
# include "dispmap.h"
#endif /* _dispmap_ */

/*
 * These are symbols for the known machine types
 */
#define MACH_XTERM "xterm"

/*
 * get machine type from interactive menu
 */
extern struct m_info *holdHands PROTO((const char *default_machinetype));

/*
 * work out which X display the user is sat at if
 * we can't do it easily elsewhere
 */
extern char *findDisplay PROTO((char s[], int size_of_s));

/*
 * this routine says what the machine looks like
 * from OPS' viewpoint.  Rewrite to suit your site
 * if necessary.  Return a pointer to a suitable structure
 * if a match found, otherwise NULL.
 */
extern struct m_info *machDetails PROTO((char *display));

/*
 * given machine type, return the machine's details,
 * or NULL if no match
 */
extern struct m_info *searchMachines PROTO((char *machinetype));
