/*
 * $Source: /u1/src/local/bin/xterm-wrapper/RCS/mach.c,v $
 *
 * Get machine and display types
 *
 * This code is copyright      The University of Kent (UKC)
 *                    and      Tony Curtis
 *                             1991
 *
 * If you change or use this file for your own purposes
 * please make sure this copyright notice is retained.
 *
 * Copyright (C) 1993 David Beckett, University of Kent at Canterbury
 *
 */

#ifndef lint
static char rcsid[] = "$Id: mach.c,v 1.7 1995/06/08 16:55:09 djb1 Exp $";
#endif /* lint */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/param.h>

#include "libdjb.h"

#include "mach.h"

/*
 * get machine type from interactive menu
 */
struct m_info *
holdHands(default_machinetype)
  const char *default_machinetype;
{
	struct m_info *mp;
	struct m_info *tmp;
	char reply[BUFSIZ+1];
	char *p;
	
	printf("The supported terminal types are:\n\n");
	printf("%12s  %s\n", "Machine", "Terminal");
	printf("%12s  %s\n", "-------", "--------");
	setminfoent();
	for (;;) {
		mp = getminfoent();
		if (mp == NULL)
			break;
		printf("%12s  %s", mp->m_machinetype, mp->m_termtype);
		if (default_machinetype !=NULL &&
		    !strcmp(mp->m_machinetype, default_machinetype))
		  puts(" (default for this display)");
		else
		  putchar('\n');
	}
	printf("\n");
	for (;;) {
		printf("  > "); fflush(stdout);

		/* EOT */
		if (fgets(reply, sizeof reply, stdin) == NULL)
			exit(0);
		p = reply;
		p[strlen(p)-1] = '\0';
		/* ignore initial spaces */
		while (isspace(*p))
			++p;
		/* ignore blank lines */
		if (*p == '\0')
			continue;
		if (strcmp(p, "help") == 0 || strcmp(p, "?") == 0)
			puts("  Choose the correct machine type on the left");
		else {
			tmp = searchMachines(p);
			/* found a match - return it */
			if (tmp != NULL)
				break;
			printf("  I don't recognise `%s'\n", p);
		}
	}
	printf("We'll need the `%s' key setup, the `%s' resources and\nthe '%s' application terminal type\n",
	       tmp->m_termtype, tmp->m_resource, tmp->m_apptermtype);
	return tmp;
}

/*
 * work out which X display the user is sat at.  We
 * only do this if DISPLAY couldn't be found.
 */
char *
findDisplay(s, size)
char *s;
int size;
{
	FILE *pp = NULL;
#ifdef UKC_XDISPLAY
        pp=popen("/usr/local/bin/xdisplay", "r");
#endif
	if (pp == NULL)
	  errf("can't find your screen name");
	if (fgets(s, size, pp) == NULL)
	  return NULL;
	pclose(pp);
	return s;
}

/*
 * this routine says what the machine looks like
 * from OPS' viewpoint.  Rewrite to suit your site
 * if necessary.  Return a pointer to a suitable structure
 * if a match found, otherwise NULL.
 */
struct m_info *
machDetails(dpy)
     char *dpy;
{
	char *coldot;
	struct d_info *dp;
	char shorten[MAXPATHLEN+1];

	/*
	 * shorten long display name if necessary:
	 * remove display number and then get short
	 * hostname
	 */
	strcpy(shorten, dpy);
	coldot = strchr(shorten, ':');
	if (coldot != NULL)
		*coldot = '\0';
	coldot = strchr(shorten, '.');
	if (coldot != NULL)
		*coldot = '\0';

	/*
	 * search table:
	 * return required info if match found,
	 * otherwise check on special cases
	 */
	dp = getdinfobyname(shorten);
	if (dp != NULL)
		return getminfobyname(dp->d_machinetype);


	/* special case for X terminals */
	if (strncmp(shorten, "xt", 2) == 0)
		return getminfobyname((char*)MACH_XTERM);


	/* catch-all if nothing will match */
	return NULL;
}

/*
 * given machine type, return the machine's details,
 * or NULL if no match
 */
struct m_info *
searchMachines(mtype)
char *mtype;
{
	return getminfobyname(mtype);
}
