/*
 * $Source: /usr/l/src/local/bin/xterm-wrapper/RCS/dispmap.c,v $
 *
 * Handle display and machine database file reading
 *
 * This code is copyright      The University of Kent (UKC)
 *                    and      Tony Curtis
 *                             1991
 *
 * If you change or use this file for your own purposes
 * please make sure this copyright notice is retained.
 *
 * Copyright (C) 1993 David Beckett, University of Kent at Canterbury
 *
 */

#ifndef lint
static char rcsid[] = "$Id: dispmap.c,v 1.6 1994/11/24 11:20:04 djb1 Exp $";
#endif /* lint */

/*
 * discover the terminal type from the display name.
 * We also have to find out what the correct X resource
 * settings are.
 */

#include <stdio.h>
#include <ctype.h>

#include "libdjb.h"

#include "dispmap.h"
#include "paths.h"

static const char *Display_Map_Path = DISPLAY_MAP_PATH;
static const char *Machine_Map_Path = MACHINE_MAP_PATH;

struct d_info *
getdinfobyname(dpy)
char *dpy;
{
	struct d_info *dp;

	setdinfoent();

	for (;;) {
		dp = getdinfoent();
		if (dp == NULL)
			break;
		if (stricmp(dp->d_display, dpy) == 0)
			return dp;
	}
	return NULL;
}

static int dfd_closed = 1;
static FILE *dfd;

static FILE *d_open PROTO((void));

#ifdef USEMALLOC
static char *trapmalloc();
#endif

struct d_info *
getdinfoent()
{
	static struct d_info d;
	static char d_line[BUFSIZ+1];
	char *lp, *lq;

	if (dfd_closed)
		dfd = d_open();

	if (dfd == NULL)
	  errf("unable to open `%s' for display info",
		DISPLAY_MAP_PATH);

      again:
	if (fgets(d_line, sizeof d_line, dfd) == NULL)
		return NULL;

	/* parse the line for "DisplayName MachineType" */
	d_line[strlen(d_line)-1] = '\0';
	lp = d_line;
	/* skip any space */
	while (*lp && isspace(*lp))
		++lp;
	/* ignore blank lines and comments */
	if (*lp == '\0' || *lp == '#')
		goto again;
	/* lq will be the display name */
	lq = lp;
	while (*lp && (! isspace(*lp)))
		++lp;
	if (*lp == '\0')
		errf("missing machine type for display `%s'", lq);
	/* terminate string */
	*lp = '\0';
#ifdef USEMALLOC
	d.d_display = trapmalloc(strlen(lq)+1);
	strcpy(d.d_display, lq);
#else
	d.d_display = lq;
#endif
	/* now get the  machine type */
	++lp;
	/* skip any space */
	while (*lp && isspace(*lp))
		++lp;
	lq = lp;
	while (*lp && (! isspace(*lp)))
		++lp;	
	/* terminate string */
	*lp = '\0';
#ifdef USEMALLOC
	d.d_machinetype = trapmalloc(strlen(lq)+1);
	strcpy(d.d_machinetype, lq);
#else
	d.d_machinetype = lq;
#endif
	return &d;
}

void
setdinfoent()
{
	if (dfd_closed)
		dfd = d_open();
	else
		rewind(dfd);
}

static
FILE *
d_open()
{
	dfd_closed = 0;
	return fopen(Display_Map_Path, "r");
}


/* ---------------------------------------------------------------------- */


struct m_info *
getminfobyname(mtype)
char *mtype;
{
	struct m_info *mp;

	setminfoent();

	for (;;) {
		mp = getminfoent();
		if (mp == NULL)
			break;
		if (stricmp(mp->m_machinetype, mtype) == 0)
			return mp;
	}
	return NULL;
}

static int mfd_closed = 1;
static FILE *mfd;

static FILE *m_open PROTO((void));

struct m_info *
getminfoent()
{
	static struct m_info m;
	static char m_line[BUFSIZ+1];
	char *lp, *lq;

	if (mfd_closed)
		mfd = m_open();

	if (mfd == NULL)
	  errf("unable to open `%s' for machine info",
	       Machine_Map_Path);

      again:
	if (fgets(m_line, sizeof m_line, mfd) == NULL)
		return NULL;

	/* parse the line for "MachineType TermType ResourceName" */
	m_line[strlen(m_line)-1] = '\0';
	lp = m_line;
	/* skip any space */
	while (*lp && isspace(*lp))
		++lp;
	/* ignore blank lines and comments */
	if (*lp == '\0' || *lp == '#')
		goto again;
	/* lq will be the machine type */
	lq = lp;
	while (*lp && (! isspace(*lp)))
		++lp;
	if (*lp == '\0')
		errf("missing terminal type and/or resource \
for machine type `%s'",
		      lq);
	/* terminate string */
	*lp = '\0';
#ifdef USEMALLOC
	m.m_machinetype = trapmalloc(strlen(lq)+1);
	strcpy(m.m_machinetype, lq);
#else
	m.m_machinetype = lq;
#endif
	/* now get the terminal type */
	++lp;
	/* skip any space */
	while (*lp && isspace(*lp))
		++lp;
	lq = lp;
	while (*lp && (! isspace(*lp)))
		++lp;	
	if (*lp == '\0')
		errf("missing resource for machine type `%s'", lq);
	/* terminate string */
	*lp = '\0';
#ifdef USEMALLOC
	m.m_termtype = trapmalloc(strlen(lq)+1);
	strcpy(m.m_termtype, lq);
#else
	m.m_termtype = lq;
#endif
	/* now get the resource */
	++lp;
	/* skip any space */
	while (*lp && isspace(*lp))
		++lp;
	lq = lp;
	while (*lp && (! isspace(*lp)))
		++lp;	
	/* terminate string */
	*lp = '\0';
#ifdef USEMALLOC
	m.m_resource = trapmalloc(strlen(lq)+1);
	strcpy(m.m_resource, lq);
#else
	m.m_resource = lq;
#endif
	/* now get the application terminal type */
	++lp;
	/* skip any space */
	while (*lp && isspace(*lp))
		++lp;
	lq = lp;
	while (*lp && (! isspace(*lp)))
		++lp;	
	/* terminate string */
	*lp = '\0';
#ifdef USEMALLOC
	m.m_apptermtype = trapmalloc(strlen(lq)+1);
	strcpy(m.m_apptermtype, lq);
#else
	m.m_apptermtype=lq;
#endif
	
	return &m;
}

void
setminfoent()
{
	if (mfd_closed)
		mfd = m_open();
	else
		rewind(mfd);
}

static
FILE *
m_open()
{
	mfd_closed = 0;
	return fopen(Machine_Map_Path, "r");
}

#ifdef USEMALLOC
static
char *
trapmalloc(len)
int len;
{
	char *z = (char *)malloc(len);
	if (z == NULL)
		errf("out of memory requesting %d bytes", len);

	return z;
}
#endif
