/*
 * $Source: /u1/src/local/bin/xterm-wrapper/RCS/cmd.c,v $
 *
 * Command running part of Xops
 *
 * This code is copyright      The University of Kent (UKC)
 *                    and      Tony Curtis
 *                             1991
 *
 * If you change or use this file for your own purposes
 * please make sure this copyright notice is retained.
 *
 * Copyright (C) 1993 David Beckett, University of Kent at Canterbury
 *
 */

#ifndef lint
static char rcsid[] = "$Id: cmd.c,v 1.9 1995/06/08 16:54:51 djb1 Exp $";
#endif  /* lint */

/*
 * run an xterm with the folding editor (or whatever) in it.
 * Need to do this because of the key mappings of different keyboards
 * under X11.  We provide a defaults file which has various keyboard maps
 * in it : ... xterm-wrapper.defaults (XTERM_WRAPPER_RESOURCES_PATH)
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#include "libdjb.h"

#include "mach.h"
#include "cmd.h"
#include "paths.h"
#include "site.h"

void
mkwindow(mi, prog)
  struct m_info *mi;
  char *prog;
{
  char cmd[BUFSIZ+1];			  /* ACME command buffer */
  char *title;				  /* window title */
  int rc;
  int nbytes;
  
  /* Merge in the X resources needed for Xops */
  sprintf(cmd, "%s -merge %s", XRDB_PATH, XTERM_WRAPPER_RESOURCES_PATH);
  (void)system(cmd);
  
  /* Form title */
  /* 'X' + program_name + `(' + termtype + `)' + 1 */
  nbytes = 1 + strlen(program_name+1) + 1 + strlen(mi->m_termtype) + 2;
  title = (char *)malloc((int)nbytes);
  sprintf(title, "X%s(%s/%s)", program_name+1,
	  mi->m_termtype,mi->m_apptermtype);
  
  /* A real hack to get around xterminal keymap changes -
   * look for a script called 'fix-$term' in the config area and
   * run it if it exists.
   */
#ifdef UKC_FUDGE_KEYMAPS
  {
    char keymap_fudge_buffer[BUFSIZ];  /* Sorry Ian */
    struct stat st;
    
    sprintf (keymap_fudge_buffer,
	     "%sfix-%s", XTERM_WRAPPER_CONFIG_PATH, mi->m_termtype);
    
    if(!stat(keymap_fudge_buffer, &st) &&
       (st.st_mode & S_IXUSR))
      {
	system(keymap_fudge_buffer);
      }
  }
    
#endif
  
  /* Form:
     exec /usr/local/X11/xterm -title TITLE -name RESOURCE
     -e .../app-wrapper APP-TERMNAME PROGRAM ARGS
     */
  
  sprintf(cmd, "exec %s -title '%s' -name '%s' -e %s %s %s",
	  XTERM_PATH, title, mi->m_resource,
	  APP_WRAPPER_PATH, mi->m_apptermtype, prog);
  
#ifdef DEBUG
  errf("Attempting to exec \"sh -c %s\"", cmd);
#endif
  
  rc=execl("/bin/sh", "sh", "-c", cmd,  (char*)0);

  errf("Unable to exec \"sh -c %s\" - %m",cmd);
  exit(1);
  
}
