/*
 * $Source: /usr/l/src/local/bin/xterm-wrapper/RCS/app.c,v $
 *
 * Wrapper programs to implement 'xwrapper' - run things that need special
 * key bindings under X
 *
 * Uses the first argument as a TERM envariable before running the rest
 * of the argument list as the real program.
 *
 * Copyright (C) 1992,1993 David Beckett, University of Kent at Canterbury
 *
 */

#ifndef lint
static char rcsid[] = "$Id: app.c,v 1.7 1994/11/18 15:17:19 djb1 Exp $";
#endif  /* lint */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "libdjb.h"

#include "paths.h"

int main PROTO((int argc, char *argv[]));


int
main(argc, argv)
  int argc;
  char *argv[];
{
  int len;
  char *termenv;
  char *prog;
  
  errf_set_progname(argv[0]);
  
  len=strlen(argv[1])+6; /* for "TERM=\0" */
  
  termenv=(char*)malloc(len);
  
  sprintf(termenv, "TERM=%s", argv[1]);
  putenv(termenv);
  
#ifdef DEBUG
  errf("Set %s", termenv);
#endif
  
  /* Notez bien - I'm not bothering to move argv */
  prog=strdup(argv[2]);
  
#ifdef DEBUG
  {
    char *list = join_vectors(argv, 2);
    errf("Attempting to exec \"%s\"", list);
    free(list);
  }
#endif
  
  execvp(prog, argv+2);
  
  errf("Unable to exec \"%s\" - %m", prog);
  errf("Sleeping - ^C to exit");
  sleep(100000000);
  return(1); /* Keep GCC happy */
}
