/* #includes *//*{{{C}}}*//*{{{*/
#ifndef NO_POSIX_SOURCE
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE 1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#include <sys/types.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <unistd.h>

#include "misc.h"
/*}}}*/

/* mymemmem    -- strstr for binary data */ /*{{{*/
/* Notes *//*{{{*/
/*

You probably heard about so called "efficient" search algorithms, which
are not of the order O(n*n).  They are a typical example of a theorey
which makes wrong assumptions for practical use, e.g. that you can
neglect any constant factors.  Those fancy algorithms are slow for
small, medium and large n, and n is usually not huge.  No startup costs
and only operations which can be translated directly to native machine
code on most machines make brute force work well here, due to using lots
of it.

*/
/*}}}*/
char *mymemmem(const char *hay, size_t haysize, const char *needle, size_t needlesize)
{
  while (haysize)
  {
    while (haysize && *needle!=*hay) { ++hay; --haysize; }
    if (haysize==0) return (char*)0;
    else
    {
      const char *oldhay,*oldneedle;
      size_t oldhaysize,oldneedlesize;
    
      oldhay=hay;
      oldneedle=needle;
      oldhaysize=haysize;
      oldneedlesize=needlesize;
      while (*hay++==*needle++ && --needlesize && --haysize);
      if (needlesize==0) return (char*)oldhay;
      else if (haysize==0) return (char*)0;
      else
      {
        hay=oldhay+1;
        haysize=oldhaysize-1;
        needle=oldneedle;
        needlesize=oldneedlesize;
        continue;
      }
    }
  }
  return (char*)0;
}
/*}}}*/
/* myrmemmem   -- rstrstr for binary data */ /*{{{*/
char *myrmemmem(const char *hay, size_t haysize, const char *needle, size_t needlesize)
{
  const char *rhay,*rneedle;

  rhay=hay+haysize-1;
  rneedle=needle+needlesize-1;
  while (haysize)
  {
    while (haysize && *rneedle!=*rhay) { --rhay; --haysize; }
    if (haysize==0) return (char*)0;
    else
    {
      const char *oldrhay,*oldrneedle;
      size_t oldhaysize,oldneedlesize;
    
      oldrhay=rhay;
      oldrneedle=rneedle;
      oldhaysize=haysize;
      oldneedlesize=needlesize;
      while (*rhay--==*rneedle-- && --needlesize && --haysize);
      if (needlesize==0) return (char*)(rhay+1);
      else if (haysize==0) return (char*)0;
      else
      {
        rhay=oldrhay-1;
        haysize=oldhaysize-1;
        rneedle=oldrneedle;
        needlesize=oldneedlesize;
        continue;
      }
    }
  }
  return (char*)0;
}
/*}}}*/
/* mystrmalloc -- return malloced copy of string */ /*{{{*/
char *mystrmalloc(const char *str)
{
  return (strcpy(malloc(strlen(str)+1),str));
}
/*}}}*/
/* myrealloc   -- ANSI conforming realloc() */ /*{{{*/
#ifdef OLD_REALLOC
#undef realloc
void *myrealloc(void *p, size_t n)
{
  return (p==(void*)0 ? malloc(n) : realloc(p,n));
}
#endif
/*}}}*/
/* getshell    -- get name of shell */ /*{{{*/
const char *getshell(void)
{
  static const char *shell=(const char*)0;

  if (shell==(const char*)0)
  {
    if ((shell=getenv("SHELL"))==(const char*)0)
    {
      struct passwd *pwd;

      if ((pwd=getpwuid(getuid()))==(struct passwd*)0)
      {
        shell="/bin/sh";
      }
      else
      {
        shell=mystrmalloc(pwd->pw_shell);
      }
    }
  }
  return shell;
}
/*}}}*/
