/* #includes *//*{{{C}}}*//*{{{*/
#ifndef NO_POSIX_SOURCE
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2
#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#include <stdlib.h>
#ifdef OLD_REALLOC
#define realloc(s,l) myrealloc(s,l)
#endif

#include "macro.h"
/*}}}*/

/* variables *//*{{{*/
static chtype *mac=(chtype*)0;
static size_t len=0,maxlen=0,runlen=0;
static int defining=0,runtimes;
static struct Macro *running=(struct Macro*)0;
/*}}}*/

/* mc_start    -- start macro *//*{{{*/
int mc_start(struct Macro *m, int count)
{
  if (defining) return -1;
  else
  {
    runtimes=count;
    running=m;
    runlen=0;
    return 0;
  }
}
/*}}}*/
/* mc_get      -- get character, from macro or from keyboard *//*{{{*/
chtype mc_get(void)
{
  chtype ch;

  if (running!=(struct Macro*)0 && running->len>runlen)
  {
    ch=*(running->mac+runlen);
    if (++runlen==running->len)
    {
      if (--runtimes) runlen=0;
      else running=(struct Macro*)0;
    }
  }
  else
  {
    (void)refresh();
    ch=getch();
  }
  if (defining)
  {
    if (len==maxlen) mac=realloc(mac,(maxlen+=255)*sizeof(chtype));
    *(mac+len++)=ch;
  }
  return ch;
}
/*}}}*/
/* mc_defstart -- start recording a macro *//*{{{*/
int mc_defstart(void)
{
  if (defining) return 0;
  else
  {
    len=0;
    defining=1;
    return 1;
  }
}
/*}}}*/
/* mc_defend   -- end macro recording *//*{{{*/
int mc_defend(struct Macro *m, int delete)
{
  if (defining)
  {
    m->len=len-delete;
    if (m->mac) free(m->mac);
    m->mac=mac;
    mac=(chtype*)0;
    len=0;
    maxlen=0;
    defining=0;
    return 1;
  }
  else return 0;
}
/*}}}*/
/* mc_null     -- init macro *//*{{{*/
void mc_null(struct Macro *m)
{
  m->mac=(chtype*)0;
  m->len=0;
}
/*}}}*/

