/*
 *  $Id: mpi.h,v 1.31 1994/06/07 22:43:53 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   mpi.h                                                              *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/* user include file for MPI programs */

#ifndef _MPI_INCLUDE
#define _MPI_INCLUDE
                                                                       
#ifdef WIN31		// MSVC does not offer a switch: compile with 4byte int's
#ifndef Int 
#define Int long	// hope that does not cause too much trouble 
#endif

#define MPID_NO_FORTRAN

typedef char far *LPSTR;
typedef LPSTR far *LPPSTR;
typedef void far *LPVOID;
typedef LPVOID far *LPPVOID;
#endif
                     
/* Results of the compare operations */
/* These should stay ordered */
#define MPI_IDENT     0
#define MPI_CONGRUENT 1
#define MPI_SIMILAR   2
#define MPI_UNEQUAL   3

/* Data types */
#ifdef MPI_SHOWINTERNAL
typedef struct MPIR_DATATYPE far *MPI_Datatype;
#else
typedef void far *MPI_Datatype;
#endif /* MPI_SHOWINTERNAL */
extern MPI_Datatype MPI_CHAR, MPI_SHORT, MPI_INT, MPI_LONG, MPI_UNSIGNED_CHAR,
       MPI_UNSIGNED_SHORT, MPI_UNSIGNED, MPI_UNSIGNED_LONG, MPI_FLOAT, 
       MPI_DOUBLE, MPI_LONG_DOUBLE, MPI_LONG_DOUBLE_INT, 
       MPI_BYTE, MPI_PACKED, MPI_UB, MPI_LB;
extern MPI_Datatype MPIR_complex_dte, MPIR_dcomplex_dte;
extern MPI_Datatype MPI_FLOAT_INT, MPI_DOUBLE_INT, MPI_LONG_INT, MPI_SHORT_INT,
                    MPI_2INT, MPIR_2real_dte, MPIR_2double_dte, 
                    MPIR_2complex_dte;

/* Communicators */
#ifdef MPI_SHOWINTERNAL
typedef struct MPIR_COMMUNICATOR far *MPI_Comm;
#else
typedef void far *MPI_Comm;
#endif /* MPI_SHOWINTERNAL */
extern MPI_Comm MPI_COMM_WORLD, MPI_COMM_SELF;

/* Groups */
#ifdef MPI_SHOWINTERNAL
typedef struct MPIR_GROUP far *MPI_Group;
#else
typedef void far *MPI_Group;
#endif /* MPI_SHOWINTERNAL */
extern MPI_Group MPI_GROUP_EMPTY;

/* Collective operations */
#ifdef MPI_SHOWINTERNAL
typedef struct MPIR_OP far *MPI_Op;
#else
typedef void far *MPI_Op;
#endif /* MPI_SHOWINTERNAL */
extern MPI_Op MPI_MAX, MPI_MIN, MPI_SUM, MPI_PROD, MPI_LAND, MPI_BAND,
              MPI_LOR, MPI_BOR, MPI_LXOR, MPI_BXOR, MPI_MINLOC, MPI_MAXLOC;

/* Permanent key values */
extern Int MPI_TAG_UB, MPI_HOST, MPI_IO;

/* Define some null objects */
#define MPI_COMM_NULL      ((MPI_Comm)0)
#define MPI_OP_NULL        ((MPI_Op)0)
#define MPI_GROUP_NULL     ((MPI_Group)0)
#define MPI_DATATYPE_NULL  ((MPI_Datatype)0)
#define MPI_REQUEST_NULL   ((MPI_Request)0)
#define MPI_ERRHANDLER_NULL 0

/* These are only guesses; make sure you change them in mpif.h as well */
#define MPI_MAX_PROCESSOR_NAME 256
#define MPI_MAX_ERROR_STRING   256

/* Pre-defined constants */
#define MPI_UNDEFINED      (-32766)
#define MPI_UNDEFINED_RANK MPI_UNDEFINED
#define MPI_KEYVAL_INVALID 0

/* Topology types */
#define MPI_GRAPH  0
#define MPI_CART   1

#define MPI_BOTTOM      (void far *)0

#define MPI_PROC_NULL   (-1)
#define MPI_ANY_SOURCE 	(-2)
#define MPI_ANY_TAG	(-1)


/* Status object.  It is the only user-visible MPI data-structure */
typedef struct { 
    Int count;
    Int MPI_SOURCE;
    Int MPI_TAG;
    Int count_in_bytes;     /* This is needed to implement MPI_Get_count
			       and MPI_Get_elements, particularly after
			       a probe */
} MPI_Status;

/* Must be able to hold any valid address.  64 bit machines may need
   to change this */
typedef long MPI_Aint;

/* The ... is correct, but the current implementation of these routines
   is not.  */
//#if defined(__STDC__) && 0
typedef void (MPI_Handler_function)( MPI_Comm far *comm, Int far *code,  
					char far *string, char far *file, Int far *line );
extern void MPI_ERRORS_ARE_FATAL( MPI_Comm far *comm, Int far *code,  
					char far *string, char far *file, Int far *line );
extern void MPI_ERRORS_RETURN( MPI_Comm far *comm, Int far *code,  
					char far *string, char far *file, Int far *line );
extern void MPIR_ERRORS_WARN( MPI_Comm far *comm, Int far *code,  
					char far *string, char far *file, Int far *line );
/*#else
typedef void (MPI_Handler_function)();
extern void MPI_ERRORS_ARE_FATAL();
extern void MPI_ERRORS_RETURN();
extern void MPIR_ERRORS_WARN();
#endif */
/* We don't do anything special with the handler function */
typedef MPI_Handler_function *MPI_Errhandler;


/* MPI request opjects */
#ifdef MPI_SHOWINTERNAL
typedef union MPIR_HANDLE far *MPI_Request;
#else
typedef void far *MPI_Request;
#endif /* MPI_SHOWINTERNAL */

/* User combination function */
//#ifdef __STDC__
typedef void (MPI_Uop)( void far *invec, void far *inoutvec, Int far *len,  
			MPI_Datatype far *datatype); 
/*#else
typedef void (MPI_Uop)();
#endif */

/* MPI Attribute copy and delete functions */
//#ifdef __STDC__
typedef Int (MPI_Copy_function)( MPI_Comm far *oldcomm, Int far *keyval, void far *extra_state,
			       void far *attr_in, LPPVOID attr_out, Int far *flag);
typedef Int (MPI_Delete_function)( MPI_Comm far *comm, Int far *keyval, void far *attr_val,
			       void far *extra_state );
/*#else
typedef Int (MPI_Copy_function)( );
typedef Int (MPI_Delete_function)( );
#endif */

/* MPI's error classes */
#include "mpi_errno.h"

/* Bindings of the MPI routines */
#include "binding.h"

#endif




