/*
 *  $Id: mpirutil.c,v 1.9 1994/06/07 21:30:16 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   mpirutil.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: mpirutil.c,v 1.9 1994/06/07 21:30:16 gropp Exp $";
#endif /* lint */

/* mpir helper routines
*/

#include <stdio.h>

void MPIR_dump_rhandle(MPIR_RHANDLE handle)
{
    printf("  handle type = %ld\n", handle.handle_type);
    printf("  source      = %ld\n", handle.source);
    printf("  tag         = %ld\n", handle.tag);
    printf("  completed   = %ld\n", handle.completed);
    printf("  datatype    = "); MPIR_dump_dte(handle.datatype,0);
}

void MPIR_dump_shandle(MPIR_SHANDLE handle)
{
    printf("  handle type = %ld\n", handle.handle_type);
    printf("  dest =        %ld\n", handle.dest);
    printf("  tag =         %ld\n", handle.tag);
    printf("  mode =        %ld\n", handle.mode);
    printf("  completed   = %ld\n", handle.completed);
    printf("  datatype    = "); MPIR_dump_dte(handle.datatype,0);
}

void MPIR_dump_queue(MPIR_QHDR far *header)
{
    MPIR_QEL far *p;

    if (!header) 
    	return;
    printf("first = 0x%lx, last = 0x%lx, maxlen = %ld, currlen = %ld\n",
			   header->first, header->last, header->maxlen, header->currlen );
    p = header->first;
    while ( p )
    {
		switch ( p->qel_type )
		{
			case MPIR_QSHANDLE:
				printf("queued send handle:\n");
				MPIR_dump_shandle( *((MPIR_SHANDLE far *) p->ptr) );
				break;
			case MPIR_QRHANDLE:
				printf("queued recv handle:\n");
				MPIR_dump_rhandle( *((MPIR_RHANDLE far *) p->ptr) );
				break;
		}
		p = p->next;
    }
}

Int MPIR_enqueue(MPIR_QHDR far *header, void far *object, MPIR_QEL_TYPE object_type)
{
    MPIR_QEL far *p;

    header->currlen++;
    if (header->currlen > header->maxlen)
		header->maxlen++;

    p           = (MPIR_QEL far *) MPIR_SBalloc( MPIR_qels );
    p->ptr      = object;
    p->qel_type = object_type;

    if (header->first == NULL)
    {
		header->first = header->last = p;
		p->prev       = p->next      = NULL;
    }
    else
    {
		p->prev            = header->last;
		p->next            = NULL;
		header->last->next = p;
		header->last       = p;
    }
    return MPI_SUCCESS;
}

Int MPIR_dequeue(MPIR_QHDR far *header, void far *object)
{
    MPIR_QEL far *p;

    p = header->first;
    while ( p != NULL )
    {
		if ( p->ptr == object )
		    break;
		else
		    p = p->next;
    }
    if ( p == NULL )
		return MPIR_ERROR((MPI_Comm)0, MPI_ERR_INTERN,"MPIR_dequeue: not found");
    else
    {
		if ( p->next != NULL )
		    p->next->prev = p->prev;
		else
		    header->last  = p->prev;
			
		if ( p->prev != NULL )
		    p->prev->next = p->next;
		else
		    header->first = p->next;
		header->currlen--;
		MPIR_SBfree( MPIR_qels, p );	/* free queue element */
    }	    
	return MPI_SUCCESS;
}

/* search posted_receive queue for message matching criteria */
/* CHANGE TO ALLOW SEARCH AND DELETE.  NEED TO INSURE THAT ONCE MATCHED,
   A POSTED MESSAGE DOESN'T MATCH AGAIN.  Note that we need to match without
   deleting so that we can implement probe 

   A flag of 1 causes a successful search to delete the element found 
 */
void MPIR_search_posted_queue( Int src, Int tag, MPIR_CONTEXT context_id, Int far *found,
				Int flag, LPPMPIR_RHANDLE  handleptr)
{
    MPIR_QHDR    far *queue = &MPIR_posted_recvs;
    MPIR_QEL     far *p;
    MPIR_RHANDLE far *q;

    p      = queue->first;
    *found = 0;
    while (p)
    {
	q = ( MPIR_RHANDLE far * ) p->ptr;
	if ( ( context_id == q->contextid ) &&
	     ( tag  == q->tag || q->tag == MPI_ANY_TAG ) &&
	     ( src  == q->source || q->source == MPI_ANY_SOURCE ))
	{
	    *found = 1;
	    *handleptr = q;
	    if (flag)
	    {
		if ( p->next != NULL )
		    p->next->prev = p->prev;
		else
		    queue->last  = p->prev;

		if ( p->prev != NULL )
		    p->prev->next = p->next;
		else
		    queue->first = p->next;
		queue->currlen--;
		MPIR_SBfree( MPIR_qels, p);	/* free queue element */
	    }
	    break;
	}
	p   = p->next;
    }
}


/* search unexpected_recv queue for message matching criteria */
/* CHANGE TO ALLOW SEARCH AND DELETE.  NEED TO INSURE THAT ONCE MATCHED,
   A POSTED MESSAGE DOESN'T MATCH AGAIN.  Note that we need to match without
   deleting so that we can implement probe 

   A flag of 1 causes a successful search to delete the element found 
 */
Int MPIR_search_unexpected_queue( Int src, Int tag, MPIR_CONTEXT context_id, 
				  Int far *found, Int flag, LPPMPIR_RHANDLE handleptr)
{
    MPIR_QHDR    far *queue = &MPIR_unexpected_recvs;
    MPIR_QEL     far *p;
    MPIR_RHANDLE far *q;

    p      = queue->first;
    *found = 0;
    while (p)
    {
	q = ( MPIR_RHANDLE far * ) p->ptr;
	if ( ( context_id == q->contextid ) && 
	     ( tag  == q->tag || tag == MPI_ANY_TAG ) &&
	     ( src  == q->source || src == MPI_ANY_SOURCE ))
	{
	    *found = 1;
	    *handleptr = q;
	    if (flag)
	    {
		if ( p->next != NULL )
		    p->next->prev = p->prev;
		else
		    queue->last  = p->prev;

		if ( p->prev != NULL )
		    p->prev->next = p->next;
		else
		    queue->first = p->next;
		queue->currlen--;
		MPIR_SBfree( MPIR_qels, p);	/* free queue element */
	    }
	    break;
	}
	p   = p->next;
    }
// Win retun added
    return MPI_SUCCESS;
}

void MPIR_dump_dte( MPI_Datatype dte, Int indent)
{
    Int i;

    switch (dte->dte_type)
    {
      case MPIR_INT:
	MPIR_Tab( indent );
	printf( "=Int\n" );
	break;
      case MPIR_FLOAT:
	MPIR_Tab( indent );
	printf( "float\n" );
	break;
      case MPIR_DOUBLE:
	MPIR_Tab( indent );
	printf( "double\n" );
	break;
      case MPIR_BYTE:
	MPIR_Tab( indent );
	printf( "byte\n" );
	break;
      case MPIR_CHAR:
	MPIR_Tab( indent );
	printf( "char\n" );
	break;
      case MPIR_LONG:
	MPIR_Tab( indent );
	printf( "long\n" );
	break;
      case MPIR_SHORT:
	MPIR_Tab( indent );
	printf( "short\n" );
	break;
      case MPIR_CONTIG:
	MPIR_Tab( indent );
	printf( "contig, count = %ld\n", dte->count );
	MPIR_dump_dte( dte->old_type, indent + 2 );
	break;
      case MPIR_VECTOR:
	MPIR_Tab( indent );
	printf( "vector, count = %ld, stride = %ld, blocklen = %ld\n",
	       dte->count, dte->stride, dte->blocklen );
	MPIR_dump_dte( dte->old_type, indent + 2 );
	break;
      case MPIR_HVECTOR:
	MPIR_Tab( indent );
	printf( "hvector, count = %ld, stride = %ld, blocklen = %ld\n",
	       dte->count, dte->stride, dte->blocklen );
	MPIR_dump_dte( dte->old_type, indent + 2 );
	break;
      case MPIR_INDEXED:
	MPIR_Tab( indent );
	printf( "indexed, count = %ld\n", dte->count );
	MPIR_dump_dte( dte->old_type, indent + 2 );
	for ( i = 0; i < dte->count; i++)
	{
	    MPIR_Tab( indent + 4 );
	    printf("index = %ld, blocklen = %ld\n",
		   dte->indices[i], dte->blocklens[i] );
	}
	break;
      case MPIR_HINDEXED:
	MPIR_Tab( indent );
	printf( "hindexed, count = %ld\n", dte->count );
	MPIR_dump_dte( dte->old_type, indent + 2 );
	for ( i = 0; i < dte->count; i++)
	{
	    MPIR_Tab( indent + 4 );
	    printf("index = %ld, blocklen = %ld\n",
		   dte->indices[i], dte->blocklens[i] );
	}
	break;
      case MPIR_STRUCT:
	MPIR_Tab( indent );
	printf( "struct, count = %ld\n", dte->count );
	for ( i = 0; i < dte->count; i++)
	{
	    MPIR_Tab( indent + 2 );
	    printf("index = %ld, blocklen = %ld\n",
		   dte->indices[i], dte->blocklens[i] );
	    MPIR_dump_dte( dte->old_types[i], indent + 2 );
	}
	break;
    }
}

/* adds to singly-linked list of flat datatype elements, returns pointer to
   head and to "next" pointer in last element, for appending.  Updates 
   current displacement.
 */
Int MPIR_flatten_dte( MPI_Datatype dte, LPPMPIR_FDTEL fdte, 
			LPPPMPIR_FDTEL tailptr, Int far *disp)
{
    Int i;
    MPIR_FDTEL far *p;
    LPPMPIR_FDTEL q, r;

/*
    printf("entering flatten dte, dte type = %d, count = %d\n",
	   dte->dte_type, dte->count);
*/
    switch (dte->dte_type)
    {
      case MPIR_INT:
	p         = (MPIR_FDTEL far *) MPIR_SBalloc( MPIR_fdtels );
	p->disp   = *disp;
	p->type   =  MPIR_INT;
	*disp     += sizeof( MPIR_INT );
	*tailptr  = &(p->next);
	*fdte     = p;
	break;
      case MPIR_FLOAT:
	p         = (MPIR_FDTEL far *) MPIR_SBalloc( MPIR_fdtels );
	p->disp   = *disp;
	p->type   =  MPIR_FLOAT;
	*disp     += sizeof( MPIR_FLOAT );
	*tailptr  = &(p->next);
	*fdte     = p;
	break;
      case MPIR_DOUBLE:
	p         = (MPIR_FDTEL far *) MPIR_SBalloc( MPIR_fdtels );
	p->disp   = *disp;
	p->type   = MPIR_DOUBLE;
	*disp    += sizeof( MPIR_DOUBLE );
	*tailptr  = &(p->next);
	*fdte     = p;
	break;
      case MPIR_CONTIG:
	r = &p;
	for (i = 0; i < dte->count; i++)
	{
	    MPIR_flatten_dte(dte->old_type, r, &q, disp );
	    if ( i == 0 )
		*fdte = p;	/* remember the first one */
	    r = q;
	}
	*tailptr = r;
	break;
      default:
	printf("mpir_flatten not implemented yet for type %d\n",dte->dte_type);
    }
    return MPI_SUCCESS;
}

void MPIR_dump_flat_dte( MPIR_FDTEL far *fdte)
{
    MPIR_FDTEL far *p;

    p = fdte;
    while ( p )
    {
		printf("(%ld,%ld),", p->type, p->disp );
		p = p->next;
    }
    printf("\n");
}

void MPIR_Tab( Int n)
{
    int i;

    for (i = 0; i < n; i++)
//	putchar(' ');
	_fputchar(' ');
}
