/*
 *  $Id: topo_test.c,v 1.4 1994/06/07 21:24:07 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   top_tes.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Topo_test - Determines the type of topology (if any) associated with a 
                communicator

Input Parameter:
. comm - communicator (handle) 

Output Parameter:
. top_type - topology type of communicator  comm (choice) 

@*/
Int MPI_Topo_test ( MPI_Comm comm, Int far *top_type)
{
  Int errno;

  if ( MPIR_TEST_COMM(comm,comm) || MPIR_TEST_ARG(top_type) )
    return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_TOPO_TEST" );
  
  /* Set the top_type */
  if ( top_type != NULL )
    (*top_type) = comm->topology.type;

  return (MPI_SUCCESS);
}
