/*
 *  $Id: graph_nbr_cnt.c,v 1.9 1994/06/07 21:24:05 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   ghp_nrc.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Graph_neighbors_count - Returns the number of neighbors of a node
                            associated with a graph topology

Input Parameters:
. comm - communicator with graph topology (handle) 
. rank - rank of process in group of comm (integer) 

Output Parameter:
. nneighbors - number of neighbors of specified process (integer) 

@*/
Int MPI_Graph_neighbors_count ( MPI_Comm comm, Int rank, Int far *nneighbors)
{
  Int errno = MPI_SUCCESS;

  if (MPIR_TEST_COMM(comm,comm) ||
	  ((comm->topology.type != MPI_GRAPH)   && ((errno = MPI_ERR_TOPOLOGY) != 0))  ||
	  ((rank                <  0)           && ((errno = MPI_ERR_RANK) != 0))      ||
	  ((rank >= (comm->topology.tag.graph.nnodes))&&((errno = MPI_ERR_RANK) != 0)) ||
      MPIR_TEST_ARG(nneighbors))
    return MPIR_ERROR( comm, errno, "Error in MPI_GRAPH_NEIGHBORS_COUNT" );

  /* Get nneighbors */
  if ( rank == 0 ) 
    (*nneighbors) = comm->topology.tag.graph.index[rank];
  else
    (*nneighbors) = comm->topology.tag.graph.index[rank] -
                    comm->topology.tag.graph.index[rank-1];
  
  return (errno);
}
