/*
 *  $Id: graph_nbr.c,v 1.10 1994/06/07 21:24:05 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   gph_nbr.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef MPIR_MIN
#define MPIR_MIN(a,b) ((a)>(b)?(b):(a))
#endif

/*@

MPI_Graph_neighbors - Returns the neighbors of a node associated 
                      with a graph topology

Input Parameters:
. comm - communicator with graph topology (handle) 
. rank - rank of process in group of comm (integer) 

Output Parameters:
. maxneighbors - size of array neighbors (integer) 
. neighbors - ranks of processes that are neighbors to specified process (array of integer) 

@*/
Int MPI_Graph_neighbors ( MPI_Comm comm, Int rank, Int far *maxneighbors,
			  Int far *neighbors)
{
  Int i, begin, end;
  Int errno = MPI_SUCCESS;

  if (MPIR_TEST_COMM(comm,comm) ||
	  ((comm->topology.type != MPI_GRAPH)   && ((errno = MPI_ERR_TOPOLOGY)) != 0)  ||
	  ((rank                <  0)           && ((errno = MPI_ERR_RANK)) != 0)      ||
	  ((rank >= (comm->topology.tag.graph.nnodes))&&((errno = MPI_ERR_RANK)) != 0) ||
      MPIR_TEST_ARG(neighbors))
    return MPIR_ERROR( comm, errno, "Error in MPI_GRAPH_NEIGHBORS" );

  /* Get neighbors */
  if ( rank == 0 ) 
    begin = 0;
  else
    begin = comm->topology.tag.graph.index[rank-1];
  end = comm->topology.tag.graph.index[rank];
  for ( i=begin; i<end; i++ )
    neighbors[i-begin] = comm->topology.tag.graph.edges[i];
  (*maxneighbors) = end - begin;
  return (errno);
}
