/*
 *  $Id: graphdims_get.c,v 1.4 1994/06/07 21:24:06 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   ghd_gt.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Graphdims_get - Retrieves graph topology information associated with a 
                    communicator

Input Parameters:
. comm - communicator for group with graph structure (handle) 

Output Parameter:
. nnodes - number of nodes in graph (integer) 
. nedges - number of edges in graph (integer) 

@*/
Int MPI_Graphdims_get ( MPI_Comm comm, Int far *nnodes, Int far *nedges)
{
  Int errno;

  if ( MPIR_TEST_COMM(comm,comm) )
    return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_GRAPHDIMS_GET" );

  /* Set nnodes */
  if ( nnodes != NULL )
    if ( comm->topology.type == MPI_GRAPH )
      (*nnodes) = comm->topology.tag.graph.nnodes;
    else
      (*nnodes) = MPI_UNDEFINED;

  /* Set nedges */
  if ( nedges != NULL ) 
    if ( comm->topology.type == MPI_GRAPH )
      (*nedges) = comm->topology.tag.graph.nedges;
    else
      (*nedges) = MPI_UNDEFINED;

  return (MPI_SUCCESS);
}
