/*
 *  $Id: cart_rank.c,v 1.11 1994/06/07 21:23:58 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   crt_rnk.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Cart_rank - Determines process rank in communicator given Cartesian
                location

Input Parameters:
. comm - communicator with cartesian structure (handle) 
. coords - integer array (of size  ndims ) specifying the cartesian coordinates of a process 
Output Parameter:
. rank - rank of specified process (integer) 

@*/
Int MPI_Cart_rank ( MPI_Comm comm, Int far *coords, Int far *rank)
{
  Int i, ndims, multiplier = 1;
  Int errno = MPI_SUCCESS;
  Int coord;

  /* Check for valid arguments */
  if ( MPIR_TEST_COMM(comm,comm) ||
	   ((rank                == NULL)       &&((errno = MPI_ERR_BUFFER) != 0))  ||
	   ((comm->topology.type != MPI_CART)   &&((errno = MPI_ERR_TOPOLOGY) != 0))||
	   ((comm->topology.tag.cart.ndims < 1) &&((errno = MPI_ERR_DIMS) != 0))    )
      return MPIR_ERROR( comm, errno, "Error in MPI_CART_RANK" );

  /* Compute rank */
  ndims = comm->topology.tag.cart.ndims;
  (*rank) = coords[ndims-1];
  if ( !(comm->topology.tag.cart.periods[ndims-1]) ) {
	if ( ((*rank) == MPI_PROC_NULL)                          ||
		 ((*rank) >= comm->topology.tag.cart.dims[ndims-1]) ||
		 ((*rank) <  0) ) {
	  (*rank) = MPI_PROC_NULL;
	  return (errno);
	}
  }
  else {
	if ( (*rank) == MPI_PROC_NULL ) {
	  (*rank) = MPI_PROC_NULL;
	  return (errno);
	}
	if ( ( (*rank) >= comm->topology.tag.cart.dims[ndims-1] ) ||
 		 ( (*rank) <  0 ) ) {
	  (*rank) = (*rank) % comm->topology.tag.cart.dims[ndims-1];
	}
  }
    
  for ( i=ndims-2; i >=0; i-- ) {
	coord = coords[i];
    if ( coord == MPI_PROC_NULL ) {
      (*rank) = MPI_PROC_NULL;
      return (errno);
	}
	if ( !(comm->topology.tag.cart.periods[i]) ) {
	  if ( (coord >= comm->topology.tag.cart.dims[i]) ||
		   (coord <  0) ) {
		(*rank) = MPI_PROC_NULL;
		return (errno);
	  }
    }
	else {
	  if ( (coord >= comm->topology.tag.cart.dims[i]) ||
		   (coord <  0) )
		coord = coord % comm->topology.tag.cart.dims[i];
	}
    multiplier *= comm->topology.tag.cart.dims[i+1];
    (*rank) += multiplier * coord;
  }

  return (errno);
}
