
/*
 *  $Id: cartdim_get.c,v 1.3 1994/06/07 21:24:00 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   crtd_gt.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Cartdim_get - Retrieves Cartesian topology information associated with a 
                  communicator

Input Parameter:
. comm - communicator with cartesian structure (handle) 

Output Parameter:
. ndims - number of dimensions of the cartesian structure (integer) 

@*/
Int MPI_Cartdim_get ( MPI_Comm  comm, Int far *ndims )
{
  Int errno;

  /* Check for valid arguments */
  if ( MPIR_TEST_COMM(comm,comm) )
    return MPIR_ERROR( comm, MPI_ERR_COMM, "Error in MPI_CARTDIM_GET" );

  /* Set dims */
  if ( ndims != NULL )
    if ( comm->topology.type == MPI_CART )
      (*ndims) = comm->topology.tag.cart.ndims;
    else
      (*ndims) = MPI_UNDEFINED;

  errno = errno;
  return (MPI_SUCCESS);
}
