/*
 *  $Id: waitany.c,v 1.7 1994/06/07 21:22:44 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   waitany.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: waitany.c,v 1.7 1994/06/07 21:22:44 gropp Exp $";
#endif /* lint */

/*@
    MPI_Waitany - Waits for any specified send or receive to complete

Input Parameters:
. count - list length (integer) 
. array_of_requests - array of requests (array of handles) 

Output Parameters:
. index - index of handle for operation that completed (integer).  In the
range 0 to count-1.
. status - status object (Status) 
@*/
Int MPI_Waitany( Int count, MPI_Request far *array_of_requests, 
					Int far *index, MPI_Status far *status)
{
    Int i, errno = MPI_SUCCESS;
    MPI_Request request;
//    Int numleft;

    *index = MPI_UNDEFINED;

    /* Check for the trivial case of nothing to do. */
    for (i=0; i<count; i++) 
    {
		if (array_of_requests[i] && array_of_requests[i]->chandle.active) 
		    break;
	}
    if (i == count) 
    	return errno;

    while (1) 
    {
		for (i = 0; i < count; i++)
	    {
		    /* Skip over null handle.  We need this for handles generated
		       when MPI_PROC_NULL is the source or destination of an 
		       operation */
		    request = array_of_requests[i];
		    if (!request || !request->chandle.active ) 
		    	continue;
	
		    if (request->chandle.completed) 
		    {
				*index = i;
				if ( request->type == MPIR_RECV ) 
				{
				    MPID_complete_recv( &request->rhandle );
				    
				    status->MPI_SOURCE	   = request->rhandle.source;
				    status->MPI_TAG	   = request->rhandle.tag;
				    status->count	   = request->rhandle.actcount;  
				    status->count_in_bytes = request->rhandle.totallen;
#ifdef MPID_RETURN_PACKED
				    if (request->rhandle.bufpos) 
						errno = MPIR_UnPackMessage( request->rhandle.bufadd, 
									   request->rhandle.count, 
									   request->rhandle.datatype, 
									   request->rhandle.source,
									   request );
#endif
			    }
				else 
				{
				    MPID_complete_send( &request->shandle, 
								        status );
#ifdef MPID_PACK_IN_ADVANCE
				    if (request->shandle.bufpos && 
						((errno = MPIR_EndPackMessage( request )) != 0))
					{
						MPIR_ERROR( MPI_COMM_WORLD, 
						   errno, "Could not pack message in MPI_WAITANY" );
					}
#endif
			    }
		        /* Spec requires, but... */
				if (!request->chandle.persistent) 
				{
				    MPI_Request_free( &array_of_requests[i] ); 
				    array_of_requests[i]    = NULL;
			    }
				else 
				{
				    request->chandle.active    = 0;
				    request->chandle.completed = MPIR_NO;
				    if (request->type == MPIR_RECV) 
				    {
						MPID_reuse_recv_handle(&request->rhandle.dev_rhandle );
					}
				    else 
				    {
						MPID_reuse_send_handle(&request->shandle.dev_shandle );
					}
			    }
				return MPI_SUCCESS;
			}
		}
		/* If nothing was ready, do a blocking wait on the device for 
		   anything to arrive; we'll then re-check the requests */
		MPID_check_device( MPID_BLOCKING );
	}
}

