/*
 *  $Id: type_vec.c,v 1.4 1994/06/13 18:08:44 doss Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   type_vc.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: type_vec.c,v 1.4 1994/06/13 18:08:44 doss Exp $";
#endif /* lint */

/*@
    MPI_Type_vector - Creates a vector (strided) datatype

Input Parameters:
. count - number of blocks (nonnegative integer) 
. blocklength - number of elements in each block 
(nonnegative integer) 
. stride - number of elements between start of each block (integer) 
. oldtype - old datatype (handle) 

Output Parameter:
. newtype - new datatype (handle) 
@*/
Int MPI_Type_vector( Int count, Int blocklen, Int stride, 
			MPI_Datatype old_type, MPI_Datatype far *newtype)
{
//  MPI_Datatype  dteptr;
  Int           errno = MPI_SUCCESS;

  /* Check for bad arguments */
  if ( MPIR_TEST_DATATYPE(MPI_COMM_WORLD,old_type) ||
   ( (old_type == (*newtype))        && ((errno = MPI_ERR_TYPE) != 0) )  ||
   ( (count   <= 0)                  && ((errno = MPI_ERR_COUNT) != 0) ) ||
   ( (blocklen <= 0)                 && ((errno = MPI_ERR_ARG) != 0) )   ||
   ( (old_type->dte_type == MPIR_UB) && ((errno = MPI_ERR_TYPE) != 0) )  ||
   ( (old_type->dte_type == MPIR_LB) && ((errno = MPI_ERR_TYPE) != 0) ) )
	return MPIR_ERROR( MPI_COMM_WORLD, errno,
					  "Error in MPI_TYPE_VECTOR" );
	
  /* Handle the case where blocklen & stride make a contiguous type */
  if ( (blocklen == stride) ||
	   (count    == 1) )
	return MPI_Type_contiguous ( count * blocklen, old_type, newtype );

  /* Reduce this to the hvector case */
  return MPI_Type_hvector ( count, blocklen, stride * old_type->extent,
						    old_type, newtype );
}
