/*
 *  $Id: type_free.c,v 1.8 1994/06/07 21:22:35 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   type_fr.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: type_free.c,v 1.8 1994/06/07 21:22:35 gropp Exp $";
#endif /* lint */

#include <malloc.h>

#ifndef MPIR_TRUE
#define MPIR_TRUE  1
#define MPIR_FALSE 0
#endif

/*@
    MPI_Type_free - Frees the datatype

Input Parameter:
. datatype - datatype that is freed (handle) 
@*/
Int MPI_Type_free ( MPI_Datatype far *datatype )
{
  Int errno = MPI_SUCCESS;

  /* Check for bad arguments */
  if (MPIR_TEST_ARG(datatype) || MPIR_TEST_DATATYPE(MPI_COMM_WORLD,*datatype))
	return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_TYPE_FREE" );

  /* Freeing null datatypes succeeds silently */
  if ( (*datatype) == MPI_DATATYPE_NULL )
	return (MPI_SUCCESS);

  /* We can't free permanent objects unless finalize has been called */
  if  ( ( (*datatype)->permanent ) && MPIR_Has_been_initialized == 1) 
	return MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_PERM_TYPE,
					  "Error in MPI_TYPE_FREE" );

  /* Free datatype */
  if ( (*datatype)->ref_count <= 1 ) {

	/* Free malloc'd memory for various datatypes */
	if ( ((*datatype)->dte_type == MPIR_INDEXED)  ||
		 ((*datatype)->dte_type == MPIR_HINDEXED) || 
		 ((*datatype)->dte_type == MPIR_STRUCT)   ) {
	  MPI_FREE ( (*datatype)->indices );
	  MPI_FREE ( (*datatype)->blocklens );
	}

	/* Free the old_type if not a struct */
	if ( ((*datatype)->dte_type != MPIR_STRUCT) && (!(*datatype)->basic) )
	  MPI_Type_free ( &((*datatype)->old_type) );
	
	/* Free the old_types of a struct */
	if ((*datatype)->dte_type == MPIR_STRUCT) {
	  Int i;

	  /* Decrease the reference count */
	  for (i=0; i<(*datatype)->count; i++)
		MPI_Type_free ( &((*datatype)->old_types[i]) );

	  /* Free the malloc'd memory */
	  MPI_FREE ( (*datatype)->old_types );
	}

	/* Free the datatype structure */
	MPIR_SBfree ( MPIR_dtes, (*datatype) );
  }
  else 
	(*datatype)->ref_count--;

  (*datatype) = MPI_DATATYPE_NULL;
  return (errno);
}


