/*
 *  $Id: testall.c,v 1.7 1994/06/07 21:22:28 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   testall.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@
    MPI_Testall - Tests for the completion of all previously initiated
    communications

Input Parameters:
. count - lists length (integer) 
. array_of_requests - array of requests (array of handles) 

Output Parameters:
. flag - (logical) 
. array_of_statuses - array of status objects (array of Status) 
@*/
Int MPI_Testall( Int count, MPI_Request far *array_of_requests,
					Int far *flag, MPI_Status far *array_of_statuses)
{
    Int i, found;
    MPI_Status status;
    MPI_Request request;

    MPID_check_device( 0 );
    found = 1;
    for (i = 0; i < count; i++)
	{
		request = array_of_requests[i];
	
		if ( request != NULL && 
		     request->chandle.active) 
		{
		    if ( request->chandle.completed == MPIR_YES) 
		    {
				if ( request->type == MPIR_SEND ) 
				{
				    MPID_complete_send( &request->shandle, 
						        &status );
				}
				else 
				{
				    MPID_complete_recv( &request->rhandle );
				    
				    array_of_statuses[i].MPI_SOURCE = request->rhandle.source;
				    array_of_statuses[i].MPI_TAG    = request->rhandle.tag;
				    array_of_statuses[i].count      = 
					request->rhandle.actcount;
				    array_of_statuses[i].count_in_bytes =
					request->rhandle.totallen;
			    }
				if (!request->chandle.persistent) 
				{
				    MPI_Request_free( &array_of_requests[i] );
				    array_of_requests[i]    = NULL;
			    }
				else 
				{
				    request->chandle.active    = 0;
				    request->chandle.completed = MPIR_NO;
				    if (request->type == MPIR_RECV) 
				    {
						MPID_reuse_recv_handle(&request->rhandle.dev_rhandle );
					}
				    else 
				    {
						MPID_reuse_send_handle(&request->shandle.dev_shandle );
					}
			    }
			}
		    else 
				found = 0;
	    }
	}
    *flag = found;	

    return MPI_SUCCESS;
}    
