/*
 *  $Id: sendrecv.c,v 1.5 1994/06/07 21:22:23 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   sendre.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: sendrecv.c,v 1.5 1994/06/07 21:22:23 gropp Exp $";
#endif /* lint */

/*@
    MPI_Sendrecv - Sends and receives a message

Input Parameters:
. sendbuf - initial address of send buffer (choice) 
. sendcount - number of elements in send buffer (integer) 
. sendtype - type of elements in send buffer (handle) 
. dest - rank of destination (integer) 
. sendtag - send tag (integer) 
. recvcount - number of elements in receive buffer (integer) 
. recvtype - type of elements in receive buffer (handle) 
. source - rank of source (integer) 
. recvtag - receive tag (integer) 
. comm - communicator (handle) 

Output Parameters:
. recvbuf - initial address of receive buffer (choice) 
. status - status object (Status) 

@*/
Int MPI_Sendrecv( 	void far *sendbuf, Int sendcount, MPI_Datatype sendtype, 
					Int dest, Int sendtag,
					void far *recvbuf, Int recvcount, MPI_Datatype recvtype,
					Int source, Int recvtag,
					MPI_Comm comm, MPI_Status far *status)
{
    Int               errno = MPI_SUCCESS;
    MPI_Status        status_array[2];
    MPI_Request       req[2];

    /* Let the Isend/Irecv check arguments */

    /* Comments on this:
       We can probably do an Irecv/Send/Wait on Irecv (blocking send)
       but what we really like to do is "send if odd, recv if even, 
       followed by send if even, recv if odd".  We can't do that, 
       because we don't require that these match up in any particular
       way (that is, there is no way to assert the "parity" of the 
       partners).  Note that the IBM "mp_bsendrecv" DOES require that
       only mp_bsendrecv be used.  

       Should there be a send/recv bit in the send mode? 
     */
    if ((errno = MPI_Irecv ( recvbuf, recvcount, recvtype,
			                 source, recvtag, comm, &req[1] )) != 0) 
		return errno;
		
	if ((errno = MPI_Isend ( sendbuf, sendcount, sendtype, dest,
							 sendtag, comm, &req[0] )) != 0)
		return errno;
		
    errno = MPI_Waitall ( 2, req, status_array );

    (*status) = status_array[1];
    
    return (errno);
}
