/*
 *  $Id: send.c,v 1.12 1994/06/07 21:22:22 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   send.c                                                             *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


#ifndef lint
static char vcid[] = "$Id: send.c,v 1.12 1994/06/07 21:22:22 gropp Exp $";
#endif /* lint */

/*@
    MPI_Send - Basic send

Input Parameters:
. buf - initial address of send buffer (choice) 
. count - number of elements in send buffer (nonnegative integer) 
. datatype - datatype of each send buffer element (handle) 
. dest - rank of destination (integer) 
. tag - message tag (integer) 
. comm - communicator (handle) 

@*/
Int MPI_Send( void far *buf, Int count, MPI_Datatype datatype, Int dest, 
				Int tag, MPI_Comm comm)
{
    Int          errno;
    MPIR_SHANDLE shandle;
    MPI_Request  request;
    MPI_Status   status;

    /* 
       Because this is a very common routine, we show how it can be
       optimized to be run "inline"; In addition, this lets us exploit
       features in the ADI to simplify the execution of blocking send 
       calls.
     */
    if (dest != MPI_PROC_NULL)
    {
        if (MPIR_TEST_COMM(comm,comm) || MPIR_TEST_COUNT(comm,count) ||
		    MPIR_TEST_DATATYPE(comm,datatype) || 
		    MPIR_TEST_SEND_TAG(comm,tag) ||
		    MPIR_TEST_SEND_RANK(comm,dest))
	    { 
		    return MPIR_ERROR(comm, errno, "Error in MPI_SEND" );
	    }

        request = (MPI_Request)&shandle;
        MPIR_Send_init( buf, count, datatype, dest, tag, comm, request, 
		        MPIR_MODE_STANDARD, 0 );
		if (shandle.datatype->is_contig) 
		{
		    shandle.dev_shandle.start				= buf;
	            shandle.dev_shandle.bytes_as_contig	= count * datatype->extent;
		    shandle.bufpos                      	= 0;
		}
#ifdef MPID_PACK_IN_ADVANCE
		else 
		{
			if ((errno = MPIR_PackMessage( buf, count, datatype, dest, request )) !=0)
		    {
			MPIR_ERROR( comm, errno, 
				    "Could not pack message in MPI_SEND" );
			}
		}
#else
		else 
		{
		    shandle.dev_shandle.start = 0;
	    }
#endif
		MPID_post_send( &shandle );
        MPID_complete_send( &shandle, &status );
#ifdef MPID_PACK_IN_ADVANCE
		if (shandle.bufpos && ((errno = MPIR_EndPackMessage( request )) != 0))
		{
		    MPIR_ERROR( comm, errno, "Could not pack message in MPI_SEND" );
	    }
#endif
    }
    return MPI_SUCCESS;
}


