/*
 *  $Id: pack_size.c,v 1.3 1994/06/07 21:22:18 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   pack_siz.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: pack_size.c,v 1.3 1994/06/07 21:22:18 gropp Exp $";
#endif /* lint */

/*@
    MPI_Pack_size - Returns the upper bound on the amount of space needed to
                    pack a message

Input Parameters:
. incount - count argument to packing call (integer) 
. datatype - datatype argument to packing call (handle) 
. comm - communicator argument to packing call (handle) 

Output Parameter:
. size - upper bound on size of packed message, in bytes (integer) 
@*/
Int MPI_Pack_size ( Int incount, MPI_Datatype  datatype, MPI_Comm comm, Int far *size)
{
	Int pad = 0;
	Int errno;
	
	if (MPIR_TEST_COMM(comm,comm) || MPIR_TEST_DATATYPE(comm,datatype) || 
		MPIR_TEST_ARG(size))
	{
		return MPIR_ERROR(comm, errno, "Error in MPI_PACK_SIZE" );
	}
	   
	/* Figure out size needed to pack type and add the biggest size
	of other types to give an upper bound */
	if (incount > 1)
		pad = (datatype->align - 
						(datatype->size % datatype->align)) % datatype->align;

	(*size) = (incount * datatype->size) +
	((incount - 1) * pad) + MPIR_dcomplex_dte->size;
	
// WIN return added
    return MPI_SUCCESS;	
}


/*+
    MPIR_Pack_size - Returns the exact amount of space needed to 
	                 pack a message
+*/
void MPIR_Pack_size ( Int incount, MPI_Datatype  type, MPI_Comm comm, Int far *size)
{
	Int pad = 0;

	comm = comm;
	
	/* Figure out size needed to pack type */
	if (incount > 1)
		pad = (type->align - (type->size % type->align)) % type->align;
		
	(*size) = (incount * type->size) + ((incount - 1) * pad);
}
