/*
 *  $Id: mperror.c,v 1.12 1994/06/13 18:23:22 doss Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   mperror.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


/*
   Fatal error handler.  Prints a message and aborts.
 */
void MPI_ERRORS_ARE_FATAL( MPI_Comm far *comm, Int far *code,  
				char far *string, char far *file, Int far *line )
{
	char buf[MPI_MAX_ERROR_STRING];
	Int  myid, result_len; 
	  
	string = string;
	file   = file;
    line   = line;

	MPID_myrank( &myid );
	MPI_Error_string( *code, buf, &result_len );
#ifndef WIN31
	fprintf( stderr, "%d - %s : %s\n", myid, 
	      string ? string : "<NO ERROR MESSAGE>", buf );
#endif /* WIN31 */
	MPI_Abort( *comm, *code );
}


/*
   Handler ignores errors.
 */   
void MPI_ERRORS_RETURN(  MPI_Comm far *comm, Int far *code,  
			char far *string, char far *file, Int far *line )
{
	comm   = comm;
    code   = code;
	string = string;
	file   = file;
    line   = line;
}


/*
   Handler prints warning messsage and returns.  Internal.  Not
   a part of the standard.
 */
void MPIR_ERRORS_WARN( MPI_Comm far *comm, Int far *code,  
			char far *string, char far *file, Int far *line )
{
	char buf[MPI_MAX_ERROR_STRING];
	Int  myid, result_len;

	comm   = comm;
	string = string;
	file   = file;
    line   = line;
    
	MPID_myrank( &myid );
	MPI_Error_string( *code, buf, &result_len );
#ifndef WIN31
	fprintf( stderr, "%d -  File: %s   Line: %d\n", myid, 
		   file, *line );
	fprintf( stderr, "%d - %s : %s\n", myid, 
	      string ? string : "<NO ERROR MESSAGE>", buf );
#endif /* WIN31 */
}


/* 
   This calls the user-specified error handler.  If that handler returns,
   we return the error code 
 */
Int MPIR_Error( MPI_Comm comm, Int code,  
		char far *string, char far *file, Int line )
{
  MPI_Errhandler handler;
//  Int            myid;

  /* Check for bad conditions */
	if (comm == MPI_COMM_NULL) 
		comm = MPI_COMM_WORLD;
	if ((handler = comm->error_handler) == MPI_ERRHANDLER_NULL) 
		handler = MPI_ERRORS_ARE_FATAL;

  /* Call handler routine */
	(*handler)( &comm, &code, string, file, &line );
	return (code);
}

