/*
 *  $Id: irsend.c,v 1.4 1994/06/07 21:22:14 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   irsend.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


#ifndef lint
static char vcid[] = "$Id: irsend.c,v 1.4 1994/06/07 21:22:14 gropp Exp $";
#endif /* lint */

/*@
    MPI_Irsend - Starts a nonblocking ready send

Input Parameters:
. buf - initial address of send buffer (choice) 
. count - number of elements in send buffer (integer) 
. datatype - datatype of each send buffer element (handle) 
. dest - rank of destination (integer) 
. tag - message tag (integer) 
. comm - communicator (handle) 
Output Parameter:
. request - communication request (handle) 

@*/
Int MPI_Irsend( void far *buf, Int count, MPI_Datatype datatype, Int dest, 
					Int tag, MPI_Comm comm, MPI_Request far *request)
{
    Int errno;
    if (dest != MPI_PROC_NULL)
    {
        /* We'll let MPI_Rsend_init find the errors */
		if ((errno = MPI_Rsend_init( buf, count, datatype, dest, tag,
									 comm, request )) != 0)
		    return errno;
		    
		(*request)->shandle.persistent = 0;
		return MPI_Start( request );
    }
    else 
		*request = 0;
		
    return MPI_SUCCESS;
}
