/*
 *  $Id: irecv.c,v 1.13 1994/06/07 21:22:14 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   irecv.c                                                            *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


#ifndef lint
static char vcid[] = "$Id: irecv.c,v 1.13 1994/06/07 21:22:14 gropp Exp $";
#endif /* lint */

/*@
    MPI_Irecv - Begins a nonblocking receive

Input Parameters:
. buf - initial address of receive buffer (choice) 
. count - number of elements in receive buffer (integer) 
. datatype - datatype of each receive buffer element (handle) 
. source - rank of source (integer) 
. tag - message tag (integer) 
. comm - communicator (handle) 

Output Parameter:
. request - communication request (handle) 
@*/
Int MPI_Irecv( void far *buf, Int count, MPI_Datatype datatype, Int source, 
				Int tag, MPI_Comm comm, MPI_Request far *request)
{
    Int err;

    if (source != MPI_PROC_NULL)
    {
        /* We'll let this routine catch the errors */
		if ((err = MPI_Recv_init( buf, count, datatype, source, tag,
								  comm, request )) != 0)
		    return err;
		(*request)->rhandle.persistent = 0;
		return MPI_Start( request );
    }
    else 
		*request = 0;

    return MPI_SUCCESS;
}
