/*
 *  $Id
 *
 *  (C) 1994 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   initsend.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: initsend.c,v 1.4 1994/06/07 21:22:12 gropp Exp $";
#endif /* lint */

/* This initializes the fields of a request structure */

Int MPIR_Send_init( void far *buf, Int count, MPI_Datatype datatype, Int dest, Int tag, 
			MPI_Comm comm, MPI_Request request, Int mode, Int nonblocking)
{
    request->type                 = MPIR_SEND;

    if (dest == MPI_PROC_NULL)
		request->shandle.dest     = dest;
    else
		request->shandle.dest     = comm->group->lrank_to_grank[dest];

    request->shandle.tag          = tag;
    request->shandle.contextid    = comm->send_context;
    request->shandle.lrank        = 
					comm->local_group->lrank_to_grank[comm->local_group->local_rank];
    request->shandle.mode         = (int)mode;
    request->shandle.datatype     = datatype;
    request->shandle.bufadd       = buf;
    request->shandle.count        = count;
    request->shandle.completed    = MPIR_NO;
    MPID_alloc_send_handle(&((request)->shandle.dev_shandle));
    MPID_set_send_is_nonblocking( &((request)->shandle.dev_shandle), nonblocking );

/* WIN : return value fixed */	
	return MPI_SUCCESS;
}
