/*
 *  $Id: create_recv.c,v 1.5 1994/06/07 21:22:07 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   creat_r.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@
    MPI_Recv_init - Builds a handle for a receive

Input Parameters:
. buf - initial address of receive buffer (choice) 
. count - number of elements received (integer) 
. datatype - type of each element (handle) 
. dest - rank of source or MPI_ANY_SOURCE (integer) 
. tag - message tag or MPI_ANY_TAG (integer) 
. comm - communicator (handle) 

Output Parameter:
. request - communication request (handle) 
@*/
Int MPI_Recv_init( void far *buf, Int count, MPI_Datatype datatype, Int source,
					Int tag, MPI_Comm comm, MPI_Request far *request)
{
    Int         errno;
    MPI_Request handleptr;

    if (MPIR_TEST_COMM(comm,comm) || MPIR_TEST_COUNT(comm,count) ||
	MPIR_TEST_DATATYPE(comm,datatype) || MPIR_TEST_RECV_TAG(comm,tag) ||
	MPIR_TEST_RECV_RANK(comm,source)) 
	return MPIR_ERROR(comm, errno, "Error in MPI_RECV_INIT" );

    *request			   = 
	(MPI_Request) MPIR_SBalloc( MPIR_rhandles );
    handleptr			   = *request;
    handleptr->type		   = MPIR_RECV;
    if (source == MPI_ANY_SOURCE)
	handleptr->rhandle.source  = source;
    else
	handleptr->rhandle.source  = comm->group->lrank_to_grank[source];
    handleptr->rhandle.tag	   = tag;
    handleptr->rhandle.contextid   = comm->recv_context;
    handleptr->rhandle.datatype	   = datatype;
    handleptr->rhandle.bufadd      = buf;
    handleptr->rhandle.count       = count;
    handleptr->rhandle.persistent  = 1;
    handleptr->rhandle.active      = 0;

    handleptr->rhandle.completed   = MPIR_NO;
    MPID_alloc_recv_handle(&((handleptr)->rhandle.dev_rhandle));

    return MPI_SUCCESS;
}
