/*
 *  $Id: buffree.c,v 1.3 1994/06/07 21:22:04 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   buffree.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop


#ifndef lint
static char vcid[] = "$Id: buffree.c,v 1.3 1994/06/07 21:22:04 gropp Exp $";
#endif /* lint */

/*@
  MPI_Buffer_detach - Removes an existing buffer (for use in MPI_Bsend etc)

Output Parameters:
. buffer - initial buffer address (choice) 
. size - buffer size, in bytes (integer) 
@*/
Int MPI_Buffer_detach( LPPVOID buffer, Int far *size)
{
/* If we are using the buffer, we must first wait on all pending messages */

	*buffer		 = MPIR_Buffer;
	*size		 = MPIR_Buffer_size;

	MPIR_Buffer	 = 0;
	MPIR_Buffer_size = 0; 

/* WIN : return value fixed */	
	return MPI_SUCCESS;
}

