/*
 *  $Id: init.c,v 1.40 1994/06/07 21:28:45 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   init.c                                                             *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h> 
#include <string.h>

#ifndef lint
static char vcid[] = "$Id: init.c,v 1.40 1994/06/07 21:28:45 gropp Exp $";
#endif /* lint */

MPI_Comm  MPI_COMM_WORLD;
MPI_Comm  MPI_COMM_SELF;
MPI_Group MPI_GROUP_EMPTY;
/* #define DEBUG(a) {a}  */
#define DEBUG(a)

#if defined(MPI_rs6000) || defined(MPI_hpux)
#define mpir_init_fdtes_ mpir_init_fdtes
#define mpir_init_fcm_   mpir_init_fcm
#define mpir_init_fop_   mpir_init_fop
#define mpir_init_flog_  mpir_init_flog
#endif

#ifdef MPI_cray
#define mpir_init_fdtes_ MPIR_INIT_FDTES
#define mpir_init_fcm_   MPIR_INIT_FCM
#define mpir_init_fop_   MPIR_INIT_FOP
#define mpir_init_flog_  MPIR_INIT_FLOG
#endif

/* Global memory management variables for fixed-size blocks */
void  far *MPIR_shandles;        /* sbcnst MPIR_SHANDLES */
void  far *MPIR_rhandles;        /* sbcnst MPIR_RHANDLES */
void  far *MPIR_dtes;      /* sbcnst datatype elements */
void  far *MPIR_qels;      /* sbcnst queue elements */
void  far *MPIR_fdtels; /* sbcnst flat datatype elements */
void  far *MPIR_hbts;   /* sbcnst height balanced tree roots for cacheing */
void  far *MPIR_hbt_els;/* sbcnst height balanced tree nodes for cacheing */

/* Global queues */
MPIR_QHDR MPIR_posted_recvs;
MPIR_QHDR MPIR_unexpected_recvs;

/* Global pre-assigned datatypes */
MPI_Datatype MPI_INT;
MPI_Datatype MPI_FLOAT;
MPI_Datatype MPI_DOUBLE;
MPI_Datatype MPI_LONG;
MPI_Datatype MPIR_complex_dte; 
MPI_Datatype MPIR_dcomplex_dte;
MPI_Datatype MPI_SHORT;
MPI_Datatype MPI_CHAR;
MPI_Datatype MPI_BYTE;
MPI_Datatype MPI_UNSIGNED_CHAR;
MPI_Datatype MPI_UNSIGNED_SHORT;
MPI_Datatype MPI_UNSIGNED_LONG;
MPI_Datatype MPI_UNSIGNED;
MPI_Datatype MPI_LONG_DOUBLE;
MPI_Datatype MPI_PACKED;
MPI_Datatype MPI_UB;
MPI_Datatype MPI_LB;
// MPI_Datatype MPIR_Init_basic_datatype( );

/* C Datatypes for MINLOC and MAXLOC functions */
MPI_Datatype MPI_FLOAT_INT;
typedef struct {
  float  var;
  Int    loc;
} MPI_FLOAT_INT_struct;
MPI_FLOAT_INT_struct MPI_FLOAT_INT_var;

MPI_Datatype MPI_DOUBLE_INT;
typedef struct {
  double var;
  Int    loc;
} MPI_DOUBLE_INT_struct;
MPI_DOUBLE_INT_struct MPI_DOUBLE_INT_var;

MPI_Datatype MPI_LONG_INT;
typedef struct {
  long   var;
  Int    loc;
} MPI_LONG_INT_struct;
MPI_LONG_INT_struct MPI_LONG_INT_var;

MPI_Datatype MPI_SHORT_INT;
typedef struct {
  short  var;
  Int    loc;
} MPI_SHORT_INT_struct;
MPI_SHORT_INT_struct MPI_SHORT_INT_var;

/* rs6000's and IRIX assert STDC but do not implement long double. */
#if defined(__STDC__) && !(defined(MPI_rs6000) || defined(MPI_IRIX))
MPI_Datatype MPI_LONG_DOUBLE_INT;
typedef struct {
  long double   var;
  Int           loc;
} MPI_LONG_DOUBLE_INT_struct;
MPI_LONG_DOUBLE_INT_struct MPI_LONG_DOUBLE_INT_var;
#endif

/* FORTRAN Datatypes for MINLOC and MAXLOC functions */
MPI_Datatype MPI_2INT; /* For C also */
MPI_Datatype MPIR_2real_dte;
MPI_Datatype MPIR_2double_dte;
MPI_Datatype MPIR_2complex_dte;

/* Global MPIR process id (from device) */
Int MPIR_tid;

/* Predefined combination functions */
MPI_Op MPI_MAX, MPI_MIN, MPI_SUM, MPI_PROD, MPI_LAND, MPI_BAND, 
               MPI_LOR, MPI_BOR, MPI_LXOR, MPI_BXOR, MPI_MAXLOC, MPI_MINLOC;

/* Permanent attributes */
Int MPI_TAG_UB, MPI_HOST, MPI_IO;

/* Global buffer */
Int MPIR_Buffer_size = 0;
void  far *MPIR_Buffer = 0;

/* Command-line flags */
Int MPIR_Print_queues = 0;

/* Fortran logical values */
/* NOTE: we really have to get these for each system (possibly by calling a
    routine) and make sure that the MPI routines whose Fortran bindings
    use LOGICAL convert to/from these values 
 */
Int MPIR_F_TRUE = 1, MPIR_F_FALSE = 0;

/* 
   If I want to use __STDC__, I need to include the full prototypes of
   these functions ... 
 */
extern void MPIR_MAXF(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_MINF(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_SUM(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_PROD(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_LAND(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_BAND(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_LOR(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_BOR(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_LXOR(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_BXOR(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_MAXLOC(void far *, void far *, Int far *, MPI_Datatype far *);
extern void MPIR_MINLOC(void far *, void far *, Int far *, MPI_Datatype far *);

/*@
   MPI_Init - Initialize the MPI execution environment

   Input Parameters:
.  argc - Pointer to the number of arguments 
.  argv - Pointer to the argument vector

   Command line arguments:
   MPI specifies no command-line arguments but does allow an MPI 
   implementation to make use of them.

.   -mpiqueue - print out the state of the message queues when MPI_FINALIZE
   is called.  All processors print; the output may be hard to decipher.  This
   is intended as a debugging aid.
.   -mpiversion - print out the version of the implemenation (NOT of MPI).

.  -chdebug - (Chameleon device only) Print out the Chameleon device operations
.  -chmemdebug - (Chameleon device only) Print out a list of unreclaimed
   memory.  This requires that MPI be built with the -DMPIR_DEBUG_MEM
   switch.  This is intended for debugging the MPI implementation itself.
.  -chmsg - (Chameleon device only) Print out the number of messages 
            received, by category, when the program exits.
   
   Notes:
   Note that the Fortran binding for this routine has only the error return
   argument (MPI_INIT(ierror))
@*/
int MPI_Init(int far *argc, LPPSTR far *argv)
{
    Int            size;
    LPPSTR	   Argv;
    MPI_Datatype   type[3];
    MPI_Aint       disp[3];
    Int            blln[3];

    if (MPIR_Has_been_initialized) 
	    return (int)(MPIR_ERROR( (MPI_Comm)0, MPI_ERR_INIT, 
	    					"Can not MPI_INIT again" ));

    Argv = NULL;
    if (argv) Argv = *argv;
    MPID_INIT( argc, Argv );

    DEBUG(MPID_myrank( &MPIR_tid);)
    DEBUG(printf("[%d] About to do allocations\n", MPIR_tid);)

    /* initialize memory allocation data structures */
    MPIR_shandles   = MPIR_SBinit( sizeof( MPIR_SHANDLE ), 100, 100 );
    MPIR_rhandles   = MPIR_SBinit( sizeof( MPIR_RHANDLE ), 100, 100 );
    MPIR_dtes       = MPIR_SBinit( sizeof( struct MPIR_DATATYPE ), 100, 100 );
    MPIR_qels       = MPIR_SBinit( sizeof( MPIR_QEL ), 100, 100 );
    MPIR_fdtels     = MPIR_SBinit( sizeof( MPIR_FDTEL ), 100, 100 );
    MPIR_hbts       = MPIR_SBinit( sizeof( MPIR_HBT ), 5, 5 );
    MPIR_hbt_els    = MPIR_SBinit( sizeof( MPIR_HBT_node ), 20, 20);

    /* set up pre-defined data types */
    DEBUG(printf("[%d] About to create datatypes\n", MPIR_tid);)
    MPI_INT		     = MPIR_Init_basic_datatype( MPIR_INT, sizeof(Int) );
    MPI_FLOAT		     = MPIR_Init_basic_datatype( MPIR_FLOAT, sizeof(float) );
    MPI_DOUBLE		     = MPIR_Init_basic_datatype( MPIR_DOUBLE, 
					        sizeof( double ) );
    MPIR_complex_dte	     = MPIR_Init_basic_datatype( MPIR_COMPLEX, 
						   2 * sizeof( float ) );
    MPIR_complex_dte->align  = sizeof( float );
    MPIR_dcomplex_dte	     = MPIR_Init_basic_datatype( MPIR_DOUBLE_COMPLEX, 
						  2 * sizeof( double ) );
    MPIR_dcomplex_dte->align = sizeof( double );
    MPI_LONG		     = MPIR_Init_basic_datatype( MPIR_LONG, sizeof( long ) );
    MPI_SHORT		     = MPIR_Init_basic_datatype( MPIR_SHORT, 
						  sizeof( short ) );
    MPI_CHAR		     = MPIR_Init_basic_datatype( MPIR_CHAR, sizeof( char ) );
    MPI_BYTE		     = MPIR_Init_basic_datatype( MPIR_BYTE, sizeof( char ) );
    MPI_UNSIGNED_CHAR	     = MPIR_Init_basic_datatype( MPIR_UCHAR, 
					       sizeof( unsigned char ) );
    MPI_UNSIGNED_SHORT	     = MPIR_Init_basic_datatype( MPIR_USHORT, 
					        sizeof( unsigned short ) );
    MPI_UNSIGNED_LONG	     = MPIR_Init_basic_datatype( MPIR_ULONG, 
					       sizeof( unsigned long ) );
    MPI_UNSIGNED	     = MPIR_Init_basic_datatype( MPIR_UINT, 
					       sizeof( unsigned Int ) );
    MPI_PACKED		     = MPIR_Init_basic_datatype( MPIR_PACKED, 1 );
    MPI_UB		     = MPIR_Init_basic_datatype( MPIR_UB, 0 );
    MPI_UB->align	     = 1;
    MPI_UB->elements	     = 0;
    MPI_UB->count	     = 0;

    MPI_LB		     = MPIR_Init_basic_datatype( MPIR_LB, 0 );
    MPI_LB->align	     = 1;
    MPI_LB->elements	     = 0;
    MPI_LB->count	     = 0;

/* rs6000's and IRIX's assert STDC but do not implement long double. */
#if defined(__STDC__) && !(defined(MPI_rs6000) || defined(MPI_IRIX))
    MPI_LONG_DOUBLE	= MPIR_Init_basic_datatype( MPIR_LONGDOUBLE, 
						    sizeof ( long double ) );
#else
    /* Unsupported are null */
    MPI_LONG_DOUBLE = 0;
#endif

    /* Initialize FORTRAN types for MINLOC and MAXLOC */
    MPI_Type_contiguous ( 2, MPI_FLOAT, &MPIR_2real_dte );
    MPI_Type_commit ( &MPIR_2real_dte );
    MPIR_Type_permanent ( MPIR_2real_dte );

    MPI_Type_contiguous ( 2, MPI_DOUBLE, &MPIR_2double_dte );
    MPI_Type_commit ( &MPIR_2double_dte );
    MPIR_Type_permanent ( MPIR_2double_dte );

    MPI_Type_contiguous ( 2, MPIR_complex_dte, &MPIR_2complex_dte );
    MPI_Type_commit ( &MPIR_2complex_dte );
    MPIR_Type_permanent ( MPIR_2complex_dte );

    /* Initialize C & FORTRAN 2int type for MINLOC and MAXLOC */
    MPI_Type_contiguous ( 2, MPI_INT, &MPI_2INT );
    MPI_Type_commit ( &MPI_2INT );
    MPIR_Type_permanent ( MPI_2INT );

    /* Initialize C types for MINLOC and MAXLOC */
    /* I'm not sure that this is 100% portable */
    blln[0] = blln[1] = blln[2] = 1;
    type[1] = MPI_INT;   
    type[2] = MPI_UB;
    disp[0] = 0;

    type[0] = MPI_FLOAT;     
    disp[1] = (char  far *)&MPI_FLOAT_INT_var.loc - 
      (char  far *)&MPI_FLOAT_INT_var;
    disp[2] = sizeof(MPI_FLOAT_INT_struct);
    MPI_FLOAT->ref_count++;  MPI_INT->ref_count++;
    MPI_UB->ref_count++;
    MPI_Type_struct ( 3, blln, disp, type, &MPI_FLOAT_INT );
    MPIR_Type_permanent ( MPI_FLOAT_INT );
    MPI_Type_commit ( &MPI_FLOAT_INT );

    type[0] = MPI_DOUBLE;
    disp[1] = (char  far *)&MPI_DOUBLE_INT_var.loc - 
      (char  far *)&MPI_DOUBLE_INT_var;
    disp[2] = sizeof(MPI_DOUBLE_INT_struct);
    MPI_DOUBLE->ref_count++;  MPI_INT->ref_count++;
    MPI_UB->ref_count++;
    MPI_Type_struct ( 3, blln, disp, type, &MPI_DOUBLE_INT );
    MPIR_Type_permanent ( MPI_DOUBLE_INT );
    MPI_Type_commit ( &MPI_DOUBLE_INT );

    type[0] = MPI_LONG;
    disp[1] = (char  far *)&MPI_LONG_INT_var.loc - 
      (char  far *)&MPI_LONG_INT_var;
    disp[2] = sizeof(MPI_LONG_INT_struct);
    MPI_LONG->ref_count++;  MPI_INT->ref_count++;
    MPI_UB->ref_count++;
    MPI_Type_struct ( 3, blln, disp, type, &MPI_LONG_INT );
    MPIR_Type_permanent ( MPI_LONG_INT );
    MPI_Type_commit ( &MPI_LONG_INT );

    type[0] = MPI_SHORT;
    disp[1] = (char  far *)&MPI_SHORT_INT_var.loc - 
      (char  far *)&MPI_SHORT_INT_var;
    disp[2] = sizeof(MPI_SHORT_INT_struct);
    MPI_SHORT->ref_count++;  MPI_INT->ref_count++;
    MPI_UB->ref_count++;
    MPI_Type_struct ( 3, blln, disp, type, &MPI_SHORT_INT );
    MPIR_Type_permanent ( MPI_SHORT_INT );
    MPI_Type_commit ( &MPI_SHORT_INT );

/* rs6000's and IRIX's assert STDC but do not implement long double. */
#if defined(__STDC__) && !(defined(MPI_rs6000) || defined(MPI_IRIX))
    type[0] = MPI_LONG_DOUBLE;
    disp[1] = (char  far *)&MPI_LONG_DOUBLE_INT_var.loc - 
      (char  far *)&MPI_LONG_DOUBLE_INT_var;
    disp[2] = sizeof(MPI_LONG_DOUBLE_INT_struct);
    MPI_LONG_DOUBLE->ref_count++;  MPI_INT->ref_count++;
    MPI_UB->ref_count++;
    MPI_Type_struct ( 3, blln, disp, type, &MPI_LONG_DOUBLE_INT );
    MPIR_Type_permanent ( MPI_LONG_DOUBLE_INT );
    MPI_Type_commit ( &MPI_LONG_DOUBLE_INT );
#endif

    /* Set the values of the Fortran versions */
    /* Logical and character aren't portable in the code below */
#ifndef MPID_NO_FORTRAN
    DEBUG(printf("[%d] About to setup Fortran datatypes\n", MPIR_tid);)
    mpir_init_fdtes_( &MPI_INT, &MPI_FLOAT, &MPI_DOUBLE,
                     &MPIR_complex_dte, &MPIR_dcomplex_dte,
                     &MPI_INT, &MPI_CHAR, 
                     &MPI_BYTE );
#endif
    /* initialize queues */
    DEBUG(printf("[%d] About to setup message queues\n", MPIR_tid);)
    MPIR_posted_recvs.first        = MPIR_posted_recvs.last        = NULL;
    MPIR_posted_recvs.maxlen       = MPIR_posted_recvs.currlen     = 0; 

    MPIR_unexpected_recvs.first    = MPIR_unexpected_recvs.last    = NULL;
    MPIR_unexpected_recvs.maxlen   = MPIR_unexpected_recvs.currlen = 0;

    /* GROUP_EMPTY is a valid empty group */
    DEBUG(printf("[%d] About to create groups and communicators\n", MPIR_tid);)
    MPI_GROUP_EMPTY     = MPIR_CreateGroup(0);
    MPI_GROUP_EMPTY->permanent = 1;

    MPI_COMM_WORLD              = MPI_NEW(struct MPIR_COMMUNICATOR);    
    MPI_COMM_WORLD->comm_type   = MPIR_INTRA;
    MPID_mysize( &size );
    MPID_myrank( &MPIR_tid);
    MPI_COMM_WORLD->group         = MPIR_CreateGroup( size );
    MPIR_SetToIdentity( MPI_COMM_WORLD->group );
    MPIR_Group_dup ( MPI_COMM_WORLD->group, &(MPI_COMM_WORLD->local_group) );
    MPI_COMM_WORLD->send_context  = MPIR_WORLD_PT2PT_CONTEXT;
    MPI_COMM_WORLD->recv_context  = MPIR_WORLD_PT2PT_CONTEXT;
    MPI_COMM_WORLD->topology.type = MPI_UNDEFINED;
    MPI_COMM_WORLD->error_handler = MPI_ERRORS_ARE_FATAL;
    MPI_COMM_WORLD->ref_count     = 1;
    MPI_COMM_WORLD->permanent     = 1;
    MPIR_Attr_create_tree ( MPI_COMM_WORLD );
    MPI_COMM_WORLD->comm_cache    = 0;     
    MPIR_Comm_make_coll ( MPI_COMM_WORLD, MPIR_INTRA );

    /* Predefined attributes for MPI_COMM_WORLD */
    DEBUG(printf("[%d] About to create keyvals\n", MPIR_tid);)
//    MPI_Keyval_create( (Int ( far *)())0, (Int ( far *)())0, &MPI_TAG_UB, (void  far *)0 );
    MPI_Keyval_create( NULL, NULL, &MPI_TAG_UB, NULL );
//    MPI_Keyval_create( (Int ( far *)())0, (Int ( far *)())0, &MPI_HOST,   (void  far *)0 );
    MPI_Keyval_create( NULL, NULL, &MPI_HOST, NULL );
//    MPI_Keyval_create( (Int ( far *)())0, (Int ( far *)())0, &MPI_IO,     (void  far *)0 );
    MPI_Keyval_create( NULL, NULL, &MPI_IO,   NULL );
    ((MPIR_Attr_key  far *)(MPI_TAG_UB))->permanent = 1;
    ((MPIR_Attr_key  far *)(MPI_HOST))->permanent   = 1;
    ((MPIR_Attr_key  far *)(MPI_IO))->permanent     = 1;
    MPI_Attr_put( MPI_COMM_WORLD, MPI_TAG_UB, (void far *)((1L<<30)-1) );
    MPI_Attr_put( MPI_COMM_WORLD, MPI_HOST, (void far *)MPI_UNDEFINED );
    /* The following isn't strictly correct, but I'm going to leave it
       in for now.  I've tried to make this correct for a few systems
       for which I know the answer.  
     */
#if defined(MPI_rs6000)
    /* The SP1, under EUIH and EUI, does not provide language compliant
       behavior for I/O.  EUIH can't get to stdin; EUI fails to handle
       EOF's properly.  Currently, the only way I have to test for SPx
       is to look at MPI_rs6000. 
     */
    MPI_Attr_put( MPI_COMM_WORLD, MPI_IO, (void far *)MPI_PROC_NULL );
#else
    MPI_Attr_put( MPI_COMM_WORLD, MPI_IO, (void far *)MPI_ANY_SOURCE );
#endif
    /* COMM_SELF is the communicator consisting only of myself */
    MPI_COMM_SELF                = MPI_NEW(struct MPIR_COMMUNICATOR);    
    MPI_COMM_SELF->comm_type     = MPIR_INTRA;
    MPID_mysize( &size );
    MPID_myrank( &MPIR_tid);
    MPI_COMM_SELF->group         = MPIR_CreateGroup( 1 );
    MPI_COMM_SELF->group->local_rank = 0;
    MPI_COMM_SELF->group->lrank_to_grank[0] = MPIR_tid;
    MPIR_Group_dup ( MPI_COMM_SELF->group, &(MPI_COMM_SELF->local_group) );
    MPI_COMM_SELF->send_context  = MPIR_SELF_PT2PT_CONTEXT;
    MPI_COMM_SELF->recv_context  = MPIR_SELF_PT2PT_CONTEXT;
    MPI_COMM_SELF->topology.type = MPI_UNDEFINED;
    MPI_COMM_SELF->error_handler = MPI_ERRORS_ARE_FATAL;
    MPI_COMM_SELF->ref_count     = 1;
    MPI_COMM_SELF->permanent     = 1;
    MPIR_Attr_create_tree ( MPI_COMM_SELF );
    MPI_COMM_SELF->comm_cache    = 0;
    MPIR_Comm_make_coll ( MPI_COMM_SELF, MPIR_INTRA );

    /* Predefined combination functions */
    DEBUG(printf("[%d] About to create combination functions\n", MPIR_tid);)
    MPI_Op_create( MPIR_MAXF,   1, &MPI_MAX );
	MPI_MAX->permanent = 1;
    MPI_Op_create( MPIR_MINF,   1, &MPI_MIN );
	MPI_MIN->permanent = 1;
    MPI_Op_create( MPIR_SUM,    1, &MPI_SUM );
	MPI_SUM->permanent = 1;
    MPI_Op_create( MPIR_PROD,   1, &MPI_PROD );
	MPI_PROD->permanent = 1;
    MPI_Op_create( MPIR_LAND,   1, &MPI_LAND );
	MPI_LAND->permanent = 1;
    MPI_Op_create( MPIR_BAND,   1, &MPI_BAND );
	MPI_BAND->permanent = 1;
    MPI_Op_create( MPIR_LOR,    1, &MPI_LOR );
	MPI_LOR->permanent = 1;
    MPI_Op_create( MPIR_BOR,    1, &MPI_BOR );
	MPI_BOR->permanent = 1;
    MPI_Op_create( MPIR_LXOR,   1, &MPI_LXOR );
	MPI_LXOR->permanent = 1;
    MPI_Op_create( MPIR_BXOR,   1, &MPI_BXOR );
	MPI_BXOR->permanent = 1;
    MPI_Op_create( MPIR_MAXLOC, 1, &MPI_MAXLOC );
	MPI_MAXLOC->permanent = 1;
    MPI_Op_create( MPIR_MINLOC, 1, &MPI_MINLOC );
	MPI_MINLOC->permanent = 1;
#ifndef MPID_NO_FORTRAN
    DEBUG(printf("[%d] About to setup Fortran functions\n", MPIR_tid);)
    mpir_init_fop_( &MPI_MAX, &MPI_MIN, &MPI_SUM, &MPI_PROD, 
                    &MPI_LAND, &MPI_BAND,
                    &MPI_LOR, &MPI_BOR, &MPI_LXOR, &MPI_BXOR, 
                    &MPI_MAXLOC, &MPI_MINLOC );
#endif

#ifndef MPID_NO_FORTRAN
    mpir_init_flog_( &MPIR_F_TRUE, &MPIR_F_FALSE );
#endif

#ifndef MPID_NO_FORTRAN
    DEBUG(printf("[%d] About to setup Fortran communicators\n", MPIR_tid);)
    mpir_init_fcm_( &MPI_COMM_WORLD, &MPI_COMM_SELF, &MPI_GROUP_EMPTY );
#endif
    DEBUG(printf("[%d] About to search for argument list options\n",MPIR_tid);)
    /* Search for "-mpi debug" options etc.  We need a better interface.... */
    if (argv && *argv) {
	Int i;
	for (i=1; i<*argc; i++) {
	    if ((*argv)[i]) {
		if (_fstrcmp( (*argv)[i], "-mpiqueue" ) == 0) {
		    MPIR_Print_queues = 1;
		    /* Should remove argument ... */
		    }
		else if (_fstrcmp((*argv)[i],"-mpiversion" ) == 0) {
		    printf( "MPI model implementation %f3.1\n", 
			   PATCHLEVEL );
		    /* Should remove argument ... */
		    }
		}
	    }
	}
#ifdef DEVICE_CHAMELEON
    DEBUG(printf("[%d] About to check for -chdebug\n", MPIR_tid);)
    if (argv && *argv && SYArgHasName( argc, *argv, 1, "-chdebug" )) {
	MPID_SetSendDebugFlag( 1 );
	MPID_SetRecvDebugFlag( 1 );
    }
    DEBUG(printf("[%d] About to check for -chmemdebug\n", MPIR_tid);)
    if (argv && *argv && SYArgHasName( argc, *argv, 1, "-chmemdebug" )) {
	MPID_SetSpaceDebugFlag( 1 );
    }
    if (argv && *argv && SYArgHasName( argc, *argv, 1, "-chmsg" )) {
	MPID_SetMsgDebugFlag( 1 );
	}
#endif
    /* barrier */
    MPIR_Has_been_initialized = 1;

    DEBUG(printf("[%d] About to exit from MPI_Init\n", MPIR_tid);)
    return MPI_SUCCESS;
}

MPI_Datatype MPIR_Init_basic_datatype (int type, Int size)
{
	MPI_Datatype new;
	
	new                 = (MPI_Datatype) MPIR_SBalloc( MPIR_dtes );
	new->dte_type       = type;
	new->committed      = MPIR_YES;
	new->is_contig      = MPIR_YES;
	new->lb             = 0;
	new->ub             = size;
	new->extent         = size;
	new->size           = size;
	new->align          = size;
	new->stride         = size;
	new->elements       = 1;
	new->count          = 1;
	new->blocklen       = 1;
	new->basic          = MPIR_YES;
	new->permanent      = MPIR_YES;
	new->old_type       = new;
	return new;
}

