/*
 *  $Id: getpname.c,v 1.3 1994/06/07 21:28:44 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   getpnam.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: getpname.c,v 1.3 1994/06/07 21:28:44 gropp Exp $";
#endif /* lint */

#include <string.h>

/*@C
  MPI_Get_processor_name - Gets the name of the processor

Output Parameters:
. name - A unique specifier for the actual (as opposed to virtual) node. 
. resultlen - Length (in characters) of the name 

Notes:
The name returned should identify a particular piece of hardware; 
the exact format is implementation defined.
@*/
Int MPI_Get_processor_name( char far *name, Int far *resultlen)
{
	MPID_NODE_NAME( name, MPI_MAX_PROCESSOR_NAME );
	*resultlen = _fstrlen(name);
	return MPI_SUCCESS;
}
