/*
 *  $Id: error_string.c,v 1.5 1994/06/07 21:28:42 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   err_str.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: error_string.c,v 1.5 1994/06/07 21:28:42 gropp Exp $";
#endif /* lint */

#include <string.h>
/*@
   MPI_Error_string - Return a string for a given error code

Input Parameters:
. errorcode - Error code returned by an MPI routine 

Output Parameter:
. string - Text that corresponds to the errorcode 
. resultlen - Length of string 
@*/
Int MPI_Error_string( Int errorcode, char *string, Int *resultlen )
{
switch (errorcode & 0xff) {
    case MPI_SUCCESS:
        strcpy( string, "No error" );
	break;
    case MPI_ERR_EXHAUSTED: 
        strcpy( string, "Out of internal memory" );
        break;
    case MPI_ERR_TAG:
	strcpy( string, "Invalid message tag" );
	break;
    case MPI_ERR_COMM_NULL:
	strcpy( string, 
		 "NULL communicator argument passed to function" );
	break;
    case MPI_ERR_COMM_INTRA:
	strcpy( string,
		 "Intracommunicator is not allowed in function" );
	break;
    case MPI_ERR_COMM_INTER:
	strcpy( string,
		 "Intercommunicator is not allowed in function" );
	break;
    case MPI_ERR_ARG:
	strcpy( string, "Invalid argument" );
	break;
    case MPI_ERR_BUFFER:
	strcpy( string, "Invalid buffer pointer" );
	break;
    case MPI_ERR_COUNT:
        strcpy( string, "Invalid count argument" );
	break;
    case MPI_ERR_TYPE:
        strcpy( string, "Invalid datatype argument" );
	break;
    case MPI_ERR_ROOT:
	strcpy( string, "Invalid root" );
	break;
    case MPI_ERR_OP:
	strcpy( string, "Invalid operation" );
	break;
    case MPI_ERR_ERRORCODE:
	strcpy( string, "Invalid error code" );
	break;
    case MPI_ERR_GROUP:
	strcpy( string, "Invalid group passed to function" );
	break;
    case MPI_ERR_RANK:
        strcpy( string, "Invalid rank" );
	break;
    case MPI_ERR_TOPOLOGY:
	strcpy( string, "Invalid topology" );
	break;
    case MPI_ERR_DIMS:
        strcpy( string, "Illegal dimension argument" );
	break;
    case MPI_ERR_NULL:
        strcpy( string, "Null parameter" );
	break;
    case MPI_ERR_UNKNOWN:
	strcpy( string, "Unknown error" );
	break;
    case MPI_ERR_INTERN:
	strcpy( string, "Internal MPI error!" );
	break;
    case MPI_ERR_BAD_ARGS:
	strcpy( string, "Invalid arguments to MPI routine" );
	break;
    case MPI_ERR_INIT:
	strcpy( string, "Can not call MPI_INIT twice!" );
	break;
    case MPI_ERR_PERM_KEY:
	strcpy( string, "Can not free permanent attribute key" );
	break;
    case MPI_ERR_PERM_TYPE:
	strcpy( string, "Can not free permanent data type" );
	break;
    case MPI_ERR_BUFFER_EXISTS:
	strcpy( string,
		"Can not attach buffer when a buffer already exists" );
	break;
    case MPI_ERR_TRUNCATE:
	strcpy( string, "Message truncated" );
	break;
    case MPI_ERR_LIMIT:
	strcpy( string, "System resource limit exceeded" );
	break;
    case MPI_ERR_COMM:
	strcpy( string, "Invalid communicator" );
	break;
    case MPI_ERR_OTHER:
	strcpy( string, "Unclassified error" );
	break;
    default:
	strcpy( string, "Unexpected error value!" );
        break;
    }
*resultlen = strlen( string );
return MPI_SUCCESS;
}
