/*
 *  $Id: dmpipk.c,v 1.4 1994/06/07 21:30:13 gropp Exp $
 *
 *  (C) 1994 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   dmpipk.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h>
#include <memory.h>

#ifndef lint
static char vcid[] = "$Id: dmpipk.c,v 1.4 1994/06/07 21:30:13 gropp Exp $";
#endif

/* 
   This file contains the first pass at routines to pack and unpack datatypes
   for the ADI.  THESE WILL CHANGE
 */

/* Pack for a send.  Eventually, this will need to handle the Heterogeneous 
   case.  */
void MPIR_Pack_Hvector(char far *buf, Int count, MPI_Datatype datatype, 
						Int dest, char far *outbuf )
{
	Int count1 = datatype->count,           /* Number of blocks */
	    blocklen = datatype->blocklen;      /* Number of elements in each block */
	MPI_Aint    stride   = datatype->stride;  /* Bytes between blocks */
	Int extent = datatype->old_type->extent;  /* Extent of underlying type */
	Int blen   = blocklen * extent;
	Int c, i;

	dest = dest;

	c = count * count1;
/* Handle the special case of 4 or 8 byte items, with appropriate 
   alignment.  We do this to avoid the cost of a memcpy call for each
   element.
 */
	if (blen == 4 && ((Int)buf & 0x3) == 0 && (stride & 0x3) == 0 && 
	    sizeof(Int) == 4)
	{
	    Int far *outb = (Int far *)outbuf, far *inb = (Int far *)buf;
	    stride = stride >> 2;
	    for (i=0; i<c; i++) 
	    {
			outb[i] = *inb;
			inb    += stride;
		}
    }
	else if (blen == 8 && ((Int)buf & 0x7) == 0 && (stride & 0x7) == 0 && 
		 sizeof(double) == 8) 
	{
	    double far *outb = (double far *)outbuf, far *inb = (double far *)buf;
	    stride = stride >> 3;
	    for (i=0; i<c; i++) 
	    {
			outb[i] = *inb;
			inb    += stride;
		}
    }
	else 
	{
	    for (i=0; i<c; i++) 
	    {
			_fmemcpy( outbuf, buf, (int)blen );
			outbuf += blen; 
			buf    += stride;
		}
	}
}

void MPIR_UnPack_Hvector (char far *inbuf, Int count, MPI_Datatype datatype, 
							Int source, char far *outbuf )
{
	Int count1 = datatype->count,            /* Number of blocks */
	    blocklen = datatype->blocklen;       /* Number of elements in each block */
	MPI_Aint    stride   = datatype->stride; /* Bytes between blocks */
	Int extent = datatype->old_type->extent;  /* Extent of underlying type */
	Int blen   = blocklen * extent;
	Int c, i;

	source = source;

	c = count * count1;
	if (blen == 4 && ((Int)inbuf & 0x3) == 0 && (stride & 0x3) == 0 && 
	    sizeof(Int) == 4) 
	{
	    Int far *outb = (Int far *)outbuf, far *inb = (Int far *)inbuf;
	    stride = stride >> 2;
	    for (i=0; i<c; i++) 
	    {
			*outb = inb[i];
			outb  += stride;
		}
    }
	else if (blen == 8 && ((Int)inbuf & 0x7) == 0 && (stride & 0x7) == 0 && 
		 sizeof(double) == 8) 
	{
	    double far *outb = (double far *)outbuf, far *inb = (double far *)inbuf;
	    stride = stride >> 3;
	    for (i=0; i<c; i++) 
	    {
			*outb   = inb[i];
			outb    += stride;
		}
    }
	else 
	{
	    for (i=0; i<c; i++) 
	    {
			_fmemcpy( outbuf, inbuf, (int)blen );
			outbuf += stride;
			inbuf  += blen;
		}
    }
}

/* Get the length needed for the Hvector as a contiguous lump */
Int MPIR_HvectorLen (Int count, MPI_Datatype datatype)
{
	return datatype->size * count;
}

/*
    These routines pack/unpack data for messages.  They KNOW how the 
    message request areas are arranged, and how the send/receive routines
    known when to use these routines.
 */
Int MPIR_PackMessage (char far *buf, Int count, MPI_Datatype datatype, 
						Int dest, MPI_Request request)
{
	Int size;
	
	if (!datatype->committed) 
	    return MPI_ERR_TYPE;
	
	if (datatype->dte_type == MPIR_HVECTOR && datatype->old_type->is_contig) 
	{
	    request->chandle.bufpos = (char far *)MPI_MALLOC( datatype->size * count );
	    if (!request->chandle.bufpos) 
	    {
			return MPI_ERR_EXHAUSTED;
		}
	    MPIR_Pack_Hvector( buf, count, datatype, dest, request->chandle.bufpos );
	    request->shandle.datatype			 = datatype->old_type;
	    request->shandle.dev_shandle.start		 = request->chandle.bufpos;
	    request->shandle.dev_shandle.bytes_as_contig = count * datatype->size;
	    return MPI_SUCCESS;
	}
	else 
	{
	    /* Use the generic pack routine */
	    MPIR_Pack_size( count, datatype, MPI_COMM_WORLD, &size );
	    request->chandle.bufpos = (char far *)MPI_MALLOC( size );
	    if (!request->chandle.bufpos) 
	    {
			return MPI_ERR_EXHAUSTED;
		}
	    MPIR_Pack( buf, count, datatype, request->chandle.bufpos );
	    request->shandle.datatype			 = MPI_PACKED;
	    request->shandle.dev_shandle.start		 = request->chandle.bufpos;
	    request->shandle.dev_shandle.bytes_as_contig = size;
	    return MPI_SUCCESS;
	}
	/* return MPI_ERR_INTERN; */
}

Int MPIR_EndPackMessage (MPI_Request request)
{
	MPI_FREE( request->chandle.bufpos );
	return MPI_SUCCESS;
}

Int MPIR_SetupUnPackMessage (char far *buf, Int  count, MPI_Datatype datatype, 
								Int  source, MPI_Request request)
{
	buf    = buf;
    source = source;

	if (!datatype->committed) 
	    return MPI_ERR_TYPE;
	
	request->chandle.bufpos = (char far *)MPI_MALLOC( datatype->size * count );
	if (!request->chandle.bufpos) 
	{
	    return MPI_ERR_EXHAUSTED;
	}
	request->rhandle.dev_rhandle.bytes_as_contig = datatype->size * count;
	request->rhandle.dev_rhandle.start           = request->chandle.bufpos;
	return MPI_SUCCESS;
}

Int MPIR_UnPackMessage(char far *buf, Int  count, MPI_Datatype datatype, 
								Int  source, MPI_Request request)
{
	if (datatype->dte_type == MPIR_HVECTOR && datatype->old_type->is_contig) 
	{
	    MPIR_UnPack_Hvector( request->chandle.bufpos, count, datatype, 
				 source, buf );
	    MPI_FREE( request->chandle.bufpos );
	    return MPI_SUCCESS;
	}
	else 
	{
	    /* Use generic unpack */
	    MPIR_Unpack( buf, count, datatype, request->chandle.bufpos );
	    MPI_FREE( request->chandle.bufpos );
	    return MPI_SUCCESS;
	}
	/* return MPI_ERR_INTERN; */
}
