/*
 *  $Id: ic_merge.c,v 1.2 1994/06/07 21:24:46 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */


/***********************************************************************
*                                                                      *
*   ic_mrg.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h>
#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\context\ic.h"
#else
#include "ic.h"
#endif /* __BORLANDC__ */

/*@

MPI_Intercomm_merge - Creates an intracommuncator from an intercommunicator

Input Parameters:
. comm - Intercommunicator
. high - Used to order the groups of the two intracommunicators within comm
  when creating the new communicator.  

Output Parameter:
. comm_out - Created intracommunicator

Algorithm:
. 1) Allocate two contexts 
. 2) Local and remote group leaders swap high values
. 3) Determine the high value.
. 4) Merge the two groups and make the intra-communicator

@*/
Int MPI_Intercomm_merge ( MPI_Comm comm, Int high, MPI_Comm far *comm_out)
{
  Int              rank, errno = MPI_SUCCESS;
//  MPIR_CONTEXT     context;
  MPI_Comm         new_comm;
  Int              flag;

  /* Check for valid arguments to function */
  if (comm == MPI_COMM_NULL)
    return MPIR_ERROR(MPI_COMM_WORLD, MPI_ERR_COMM,
                      "Null communicator in MPI_INTERCOMM_MERGE");

  /* Check for intra-communicator */
  MPI_Comm_test_inter ( comm, &flag );
  if (!flag) 
    return MPIR_ERROR(comm, MPI_ERR_COMM,
		"Intra-communicator invalid in MPI_INTERCOMM_MERGE");

  /* Get my rank in the local group */
  (void) MPI_Comm_rank ( comm, &rank );

  /* Make the new communicator */
  new_comm =  MPI_NEW(struct MPIR_COMMUNICATOR);
  if (!new_comm) 
    return MPIR_ERROR( comm, MPI_ERR_EXHAUSTED,
                      "Out of space in MPI_COMM_CREATE" );
  new_comm->comm_type     = MPIR_INTRA;
  new_comm->comm_cache    = 0;
  new_comm->topology.type = MPI_UNDEFINED;
  new_comm->ref_count     = 1;
  new_comm->permanent     = 0;
  new_comm->error_handler = comm->error_handler;
  (void) MPIR_Attr_create_tree ( new_comm );
  
  /* Get the high value for our side */
  MPIR_Intercomm_high ( comm, &high );

  /* Merge the two groups according to high value */
  if (high) 
	MPI_Group_union(comm->group, comm->local_group, &(new_comm->group) );
  else 
	MPI_Group_union(comm->local_group, comm->group, &(new_comm->group) );
  MPIR_Group_dup ( new_comm->group, &(new_comm->local_group) );

  /* Allocate 2 contexts for intra-communicator */
  MPIR_Context_alloc ( comm, 2, &(new_comm->send_context));
  new_comm->recv_context = new_comm->send_context;

  /* Make the collective communicator */
  (void) MPIR_Comm_make_coll( new_comm, MPIR_INTRA );
  
  (*comm_out) = new_comm;

  return (errno);
}
