/*
 *  $Id: group_compare.c,v 1.5 1994/06/07 21:24:33 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   grp_cmp.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Group_compare - Compares two groups

Input Parameters:
. group1 - group1 (handle) 
. group2 - group2 (handle) 

Output Parameter:
. result - integer which is MPI_IDENT if the order and members of
the two groups are the same, MPI_SIMILAR if only the members are the same,
and MPI_UNEQUAL otherwise

@*/
Int MPI_Group_compare ( MPI_Group group1, MPI_Group group2, Int far *result)
{
  Int       errno = MPI_SUCCESS;
  Int       size1, size2;
  MPI_Group group_int;
  Int       size_int, i;

  if ( MPIR_TEST_GROUP(MPI_COMM_WORLD,group1) ||
       MPIR_TEST_GROUP(MPI_COMM_WORLD,group2) ||
       MPIR_TEST_ARG(result))
    return MPIR_ERROR( MPI_COMM_WORLD, errno, "Error in MPI_GROUP_COMPARE" );

  /* See if their sizes are equal */
  MPI_Group_size ( group1, &size1 );
  MPI_Group_size ( group2, &size2 );
  if ( size1 != size2 ) {
	(*result) = MPI_UNEQUAL;
	return (errno);
  }

  /* Is their intersection the same size as the original group */
  MPI_Group_intersection ( group1, group2, &group_int );
  MPI_Group_size ( group_int, &size_int );
  MPI_Group_free ( &group_int );
  if ( size_int != size1 ) {
	(*result) = MPI_UNEQUAL;
	return (errno);
  }

  /* Do a 1-1 comparison */
  (*result) = MPI_SIMILAR;
  for ( i=0; i<size1; i++ )
	if ( group1->lrank_to_grank[i] != group2->lrank_to_grank[i] ) 
	  return (errno);
  (*result) = MPI_IDENT;
  return (errno);
}
