/*
 *  $Id: comm_rgroup.c,v 1.3 1994/06/07 21:24:27 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   comm_rg.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Comm_remote_group - Accesses the remote group associated with 
                        the given inter-communicator

Input Parameter:
. comm - Communicator

Output Parameter:
. group - remote group of communicator
@*/
Int MPI_Comm_remote_group ( MPI_Comm comm, MPI_Group far *group)
{
    Int errno;
    if (MPIR_TEST_COMM(comm,comm)) 
    {
	(*group) = MPI_GROUP_NULL;
	return MPIR_ERROR( MPI_COMM_WORLD, errno, 
				"Error in MPI_COMM_REMOTE_GROUP" );
    }
    else 
    {
	MPIR_Group_dup( comm->group, group );
	return (MPI_SUCCESS);
    }
}
