/*
 *  $Id: comm_free.c,v 1.24 1994/06/07 21:24:25 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   comm_fr.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#include <malloc.h>

/*@

MPI_Comm_free - Marks the communicator object for deallocation

Input Parameter:
. comm - communicator to be destroyed (handle) 

@*/
Int MPI_Comm_free ( MPI_Comm far *comm)
{
  Int errno = MPI_SUCCESS;

  /* Check for bad arguments */
  if ( MPIR_TEST_COMM(*comm,*comm) )
	return MPIR_ERROR( MPI_COMM_WORLD, errno,
					  "Error in MPI_COMM_FREE" );

  /* Check for null communicator */
  if ((*comm) == MPI_COMM_NULL)
    return (errno);

  /* We can't free permanent objects unless finalize has been called */
  if  ( ( (*comm)->permanent == 1 ) && (MPIR_Has_been_initialized == 1) )
	return MPIR_ERROR( *comm, MPI_ERR_PERM_KEY,
					  "Error in MPI_COMM_FREE" );

  /* Free group */
  if ( (*comm)->ref_count <= 1 ) {

	/* Free the context used by this communicator */
	(void) MPIR_Context_dealloc ( (*comm), 1, (*comm)->recv_context );
	
	/* Free cache information */
	MPIR_Attr_free_tree ( *comm );
	
	/* Free collective communicator (unless it refers back to myself) */
	if ( (*comm)->comm_coll != (*comm) )
	  MPI_Comm_free ( &((*comm)->comm_coll) );

	/* Free groups */
	MPI_Group_free ( &((*comm)->group) );
	MPI_Group_free ( &((*comm)->local_group) );

	/* Free topology */
	if ( (*comm)->topology.type == MPI_CART ) 
	  MPI_FREE( (*comm)->topology.tag.cart.dims );
	else if ( (*comm)->topology.type == MPI_GRAPH )
	  MPI_FREE( (*comm)->topology.tag.graph.index );
	
	/* Free comm structure */
	MPI_FREE( *comm );
  }
  else 
	(*comm)->ref_count--;

  /* Set comm to null */
  (*comm) = MPI_COMM_NULL;
	
  return (errno);
}
