/*
 *  $Id: comm_dup.c,v 1.20 1994/06/07 21:24:24 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   comm_dp.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#include <malloc.h>
#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\context\ic.h"
#else
#include "ic.h"
#endif /* __BORLANDC__ */

/*@

MPI_Comm_dup - Duplicates an existing communicator with all its cached
               information

Input Parameter:
. comm - communicator (handle) 
Output Parameter:
. newcomm - copy of comm (handle) 

@*/
Int MPI_Comm_dup ( MPI_Comm comm, MPI_Comm far *comm_out)
{
  MPI_Comm new_comm;
  Int errno;

  /* Check for non-null communicator */
  if ( MPIR_TEST_COMM(comm,comm) ) {
    (*comm_out) = MPI_COMM_NULL;
	return MPIR_ERROR( comm, errno, "Error in MPI_COMM_DUP" );
  }

  /* Duplicate the communicator */
  new_comm                  = MPI_NEW(struct MPIR_COMMUNICATOR);
  if (!new_comm) {
	return MPIR_ERROR( comm, MPI_ERR_EXHAUSTED, 
					  "Out of space in MPI_COMM_DUP" );
  }
  (void) MPIR_Group_dup ( comm->group,       &(new_comm->group) );
  (void) MPIR_Group_dup ( comm->local_group, &(new_comm->local_group) );
  new_comm->comm_type       = comm->comm_type;
  new_comm->ref_count       = 1;
  new_comm->permanent       = 0;
  new_comm->error_handler   = new_comm->error_handler;
  new_comm->comm_cache      = 0;
  (void) MPIR_Attr_copy ( comm, new_comm ); 


  /* Duplicate intra-communicators */
  if ( comm->comm_type == MPIR_INTRA ) {
	(void) MPIR_Context_alloc ( comm, 2, &(new_comm->send_context) );
	new_comm->recv_context    = new_comm->send_context;
	new_comm->topology.type   = comm->topology.type;

	/* Copy topology info */
	if (comm->topology.type == MPI_CART) {
	  Int i, ndims;
	  new_comm->topology.tag.cart.nnodes        = 
		comm->topology.tag.cart.nnodes; 
	  new_comm->topology.tag.cart.ndims = ndims = 
		comm->topology.tag.cart.ndims;
	  new_comm->topology.tag.cart.dims          = 
		(Int far *)MPI_MALLOC( sizeof(Int) * 3 * ndims );
	  new_comm->topology.tag.cart.periods       = 
		new_comm->topology.tag.cart.dims + ndims;
	  new_comm->topology.tag.cart.position      = 
		new_comm->topology.tag.cart.periods + ndims;
	  for ( i=0; i<ndims; i++ ) {
		new_comm->topology.tag.cart.dims[i]     = 
		  comm->topology.tag.cart.dims[i];
		new_comm->topology.tag.cart.periods[i]  =
		  comm->topology.tag.cart.periods[i];
	  }
	  for ( i=0; i < ndims; i++ ) 
		new_comm->topology.tag.cart.position[i] =
		  comm->topology.tag.cart.position[i];
	}
	else if (comm->topology.type == MPI_GRAPH) {
	  Int  i, nnodes;
	  Int far *index;
	  new_comm->topology.tag.graph.nnodes = nnodes = 
		comm->topology.tag.graph.nnodes;
	  new_comm->topology.tag.graph.nedges     = 
		comm->topology.tag.graph.nedges;
	  index = comm->topology.tag.graph.index;
	  new_comm->topology.tag.graph.index      = 
		(Int far *)MPI_MALLOC(sizeof(Int) * (nnodes + index[nnodes-1]) );
	  new_comm->topology.tag.graph.edges      = 
		new_comm->topology.tag.graph.index + nnodes;
	  for ( i=0; i<nnodes; i++ )
		new_comm->topology.tag.graph.index[i] = 
		  comm->topology.tag.graph.index[i];
	  for ( i=0; i<index[nnodes-1]; i++ )
		new_comm->topology.tag.graph.edges[i] =
		  comm->topology.tag.graph.edges[i];
	}

	(void) MPIR_Comm_make_coll ( new_comm, MPIR_INTRA );
  }

  /* Duplicate inter-communicators */
  else {
	MPI_Comm     inter_comm = comm->comm_coll;
	MPI_Comm     intra_comm = comm->comm_coll->comm_coll;
	Int          rank;
	MPIR_CONTEXT recv_context, send_context;

	/* Allocate send context, inter-coll context and intra-coll context */
	MPIR_Context_alloc ( intra_comm, 3, &recv_context );

	/* If I'm the local leader, then swap context info */
	MPI_Comm_rank ( intra_comm, &rank );
	if (rank == 0) {
	  MPI_Status status;
	  
	  MPI_Sendrecv (&recv_context, 1, MPIR_CONTEXT_TYPE, 0, MPIR_IC_DUP_TAG,
			&send_context, 1, MPIR_CONTEXT_TYPE, 0, MPIR_IC_DUP_TAG,
			inter_comm, &status);
	}
	
	/* Broadcast the send context */
	MPI_Bcast(&send_context, 1, MPIR_CONTEXT_TYPE, 0, intra_comm);

	/* We all now have all the information necessary,finish building the */
	/* inter-communicator */
	new_comm->send_context  = send_context;
	new_comm->recv_context  = recv_context;
	new_comm->topology.type = MPI_UNDEFINED;

	/* Build the collective inter-communicator */
	MPIR_Comm_make_coll( new_comm, MPIR_INTER );

	/* Build the collective intra-communicator */
	MPIR_Comm_make_coll ( new_comm->comm_coll, MPIR_INTRA );
  }
  (*comm_out)               = new_comm;

  return(MPI_SUCCESS);
}

