/*
 *  $Id: comm_create.c,v 1.9 1994/06/15 18:09:24 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   comm_cr.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop
#include <malloc.h>

/*@

MPI_Comm_create - Creates a new communicator

Input Parameters:
. comm - communicator (handle) 
. group - Group, which is a subset of the group of comm  (handle) 

Output Parameter:
. comm_out - new communicator (handle) 

@*/
Int MPI_Comm_create ( MPI_Comm  comm, MPI_Group group, MPI_Comm far *comm_out)
{
  Int errno = MPI_SUCCESS;

  /* Check for invalid arguments */
  if ( MPIR_TEST_COMM(comm,comm) || 
	   MPIR_TEST_GROUP(comm,group)||
	   ((comm->comm_type == MPIR_INTER) && ((errno = MPI_ERR_COMM) !=0))  ) {
    (*comm_out) = MPI_COMM_NULL;
    return MPIR_ERROR( comm, errno, "Error in MPI_COMM_CREATE" );
  }

  /* Create the communicator */
  if (group->local_rank == MPI_UNDEFINED) {
    MPIR_CONTEXT tmp_context;
    /* I'm not in the new communciator but I'll participate in the */
    /* context creation anyway, then deallocate the context that was */
    /* allocated.  I may not need do this, but until I think about */
    /* the consequences a bit more ... */
    (void) MPIR_Context_alloc  ( comm, 2, &tmp_context ); 
    (void) MPIR_Context_dealloc( comm, 2, tmp_context );
    (*comm_out) = MPI_COMM_NULL;
  }
  else {
    MPI_Comm new_comm = (*comm_out) = MPI_NEW(struct MPIR_COMMUNICATOR);
    if (!new_comm) 
	  return MPIR_ERROR( comm, MPI_ERR_EXHAUSTED,
					"Out of space in MPI_COMM_CREATE" );
    new_comm->comm_type   = MPIR_INTRA;
    (void) MPIR_Group_dup( group, &(new_comm->group) );
	(void) MPIR_Group_dup( group, &(new_comm->local_group) );
    (void) MPIR_Context_alloc( comm, 2, &(new_comm->send_context) );
    new_comm->recv_context = new_comm->send_context;
    new_comm->comm_cache    = 0;
    new_comm->topology.type = MPI_UNDEFINED;
	new_comm->ref_count     = 1;
	new_comm->permanent     = 0;
	new_comm->error_handler = comm->error_handler;
    (void) MPIR_Attr_create_tree ( new_comm );
    (void) MPIR_Comm_make_coll( new_comm, MPIR_INTRA );
  }
  return(errno);
}

