/*
 *  $Id: attr_delval.c,v 1.12 1994/06/07 21:24:19 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   attr_dv.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

/*@

MPI_Attr_delete - Deletes attribute value associated with a key

Input Parameters:
. comm - communicator to which attribute is attached (handle) 
. keyval - The key value of the deleted attribute (integer) 

@*/
Int MPI_Attr_delete ( MPI_Comm comm, Int keyval)
{
  MPIR_HBT_node far *attr;
  MPIR_Attr_key far *attr_key = (MPIR_Attr_key far *)keyval;
  Int            errno    = MPI_SUCCESS;

  if ( MPIR_TEST_COMM(comm,comm) ||
	   ( (keyval == MPI_KEYVAL_INVALID) && ((errno = MPI_ERR_OTHER) != 0)) )
	return MPIR_ERROR(comm, errno, "Error in MPI_ATTR_DELETE");

  if (comm == MPI_COMM_WORLD && attr_key->permanent) 
	return MPIR_ERROR( comm, MPI_ERR_PERM_KEY, 
					  "Error in MPI_ATTR_DELETE" );

  MPIR_HBT_lookup(comm->attr_cache, keyval, &attr);
//  if (attr != (MPIR_HBT_node *)0) {
  if (attr != NULL) {
//	if ( attr_key->delete_fn != (Int(*)())0 ) 
	if ( attr_key->delete_fn != NULL ) 
	  errno = attr_key->delete_fn(&comm, &keyval, attr->value,
								  attr_key->extra_state );
	MPIR_HBT_delete(comm->attr_cache, keyval, &attr);
//	if ( attr != (MPIR_HBT_node *)0 ) 
	if ( attr != NULL ) 
	  (void) MPIR_HBT_free_node ( attr );
  }

  return(errno);
}
