/*
 *  $Id: opfree.c,v 1.7 1994/06/07 21:29:48 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   opfree.c                                                           *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: opfree.c,v 1.7 1994/06/07 21:29:48 gropp Exp $";
#endif /* lint */

#include <malloc.h>
#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@
  MPI_Op_free - Frees a user-defined combination function handle

Input Parameter:
. op - operation (handle) 

Notes:
op is set to MPI_OP_NULL on exit.
@*/
Int MPI_Op_free( MPI_Op far *op)
{
  Int errno;
  /* Freeing a NULL op returns successfully */
  if (MPIR_TEST_ARG(op))
      return MPIR_ERROR(MPI_COMM_WORLD,errno,"Error in MPI_OP_FREE" );
  if ( (*op) == MPI_OP_NULL )
	return (MPI_SUCCESS);

  /* We can't free permanent objects unless finalize has been called */
  if  ( ( (*op)->permanent == 1 ) && (MPIR_Has_been_initialized == 1) )
	return MPIR_ERROR( MPI_COMM_WORLD, MPI_ERR_PERM_KEY,
					  "Error in MPI_OP_FREE" );

  /* Free the op */
  MPI_FREE( (*op) );
  (*op) = MPI_OP_NULL;

  return (MPI_SUCCESS);
}
