/*
 *  $Id: global_ops.c,v 1.18 1994/06/07 21:29:46 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   global_o.c                                                         *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: global_ops.c,v 1.18 1994/06/07 21:29:46 gropp Exp $";
#endif /* lint */

/* 

Global Compute Operations 

 */

#include "mpiimpl.h"
#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

typedef struct {
  float re;
  float im; 
} s_complex;

typedef struct { 
  double re;
  double im; 
} d_complex;


void MPIR_MAXF( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MAX(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MAX(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MAX(a[i],b[i]);
    break;
  }
  case MPIR_FLOAT: {
    float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MAX(a[i],b[i]);
    break;
  }
  case MPIR_DOUBLE: {
    double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MAX(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}


void MPIR_MINF ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MIN(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MIN(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MIN(a[i],b[i]);
    break;
  }
  case MPIR_FLOAT: {
    float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MIN(a[i],b[i]);
    break;
  }
  case MPIR_DOUBLE: {
    double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_MIN(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}

#ifndef MPIR_SUM
#define MPIR_LSUM(a,b) ((a)+(b))
#endif
void MPIR_SUM ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LSUM(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LSUM(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LSUM(a[i],b[i]);
    break;
  }
  case MPIR_FLOAT: {
    float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LSUM(a[i],b[i]);
    break;
  }
  case MPIR_DOUBLE: {
    double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LSUM(a[i],b[i]);
    break;
  }
  case MPIR_COMPLEX: {
    s_complex far *a = (s_complex far *)inoutvec; s_complex far *b = (s_complex far *)invec;
    for ( i=0; i<len; i++ ) {
      a[i].re = MPIR_LSUM(a[i].re ,b[i].re);
      a[i].im = MPIR_LSUM(a[i].im ,b[i].im);
    }
    break;
  }
  case MPIR_DOUBLE_COMPLEX: {
    d_complex far *a = (d_complex far *)inoutvec; d_complex far *b = (d_complex far *)invec;
    for ( i=0; i<len; i++ ) {
      a[i].re = MPIR_LSUM(a[i].re ,b[i].re);
      a[i].im = MPIR_LSUM(a[i].im ,b[i].im);
    }
    break;
  }
  default:
    break;
  }
}



#define MPIR_LPROD(a,b) ((a)*(b))
void MPIR_PROD ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LPROD(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LPROD(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LPROD(a[i],b[i]);
    break;
  }
  case MPIR_FLOAT: {
    float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LPROD(a[i],b[i]);
    break;
  }
  case MPIR_DOUBLE: {
    double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LPROD(a[i],b[i]);
    break;
  }
  case MPIR_COMPLEX: {
    s_complex far *a = (s_complex far *)inoutvec; s_complex far *b = (s_complex far *)invec;
    for ( i=0; i<len; i++ ) {
	  s_complex c;
	  c.re = a[i].re; c.im = a[i].im;
      a[i].re = c.re*b[i].re - c.im*b[i].im;
      a[i].im = c.im*b[i].re + c.re*b[i].im;
    }
    break;
  }
  case MPIR_DOUBLE_COMPLEX: {
    d_complex far *a = (d_complex far *)inoutvec; d_complex far *b = (d_complex far *)invec;
    for ( i=0; i<len; i++ ) {
      d_complex c;
	  c.re = a[i].re; c.im = a[i].im;
      a[i].re = c.re*b[i].re - c.im*b[i].im;
      a[i].im = c.im*b[i].re + c.re*b[i].im;
    }
    break;
  }
  default:
    break;
  }
}



#ifndef MPIR_LLAND
#define MPIR_LLAND(a,b) ((a)&&(b))
#endif
void MPIR_LAND ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLAND(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLAND(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLAND(a[i],b[i]);
    break;
  }
  case MPIR_FLOAT: {
    float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLAND(a[i],b[i]);
    break;
  }
  case MPIR_DOUBLE: {
    double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLAND(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}



#ifndef MPIR_LBAND
#define MPIR_LBAND(a,b) ((a)&(b))
#endif
void MPIR_BAND ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBAND(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBAND(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBAND(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}



#ifndef MPIR_LLOR
#define MPIR_LLOR(a,b) ((a)||(b))
#endif
void MPIR_LOR ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLOR(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLOR(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLOR(a[i],b[i]);
    break;
  }
  case MPIR_FLOAT: {
    float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLOR(a[i],b[i]);
    break;
  }
  case MPIR_DOUBLE: {
    double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLOR(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}


#ifndef MPIR_LBOR
#define MPIR_LBOR(a,b) ((a)|(b))
#endif
void MPIR_BOR ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBOR(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBOR(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBOR(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}



#ifndef MPIR_LLXOR
#define MPIR_LLXOR(a,b) (((a)&&(!b))||((!a)&&(b)))
#endif
void MPIR_LXOR ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLXOR(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLXOR(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLXOR(a[i],b[i]);
    break;
  }
  case MPIR_FLOAT: {
    float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLXOR(a[i],b[i]);
    break;
  }
  case MPIR_DOUBLE: {
    double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LLXOR(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}



#ifndef MPIR_LBXOR
#define MPIR_LBXOR(a,b) ((a)^(b))
#endif
void MPIR_BXOR ( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  switch ((*type)->dte_type) {
  case MPIR_INT: {
    Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBXOR(a[i],b[i]);
    break;
  }
  case MPIR_LONG: {
    long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBXOR(a[i],b[i]);
    break;
  }
  case MPIR_SHORT: {
    short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
    for ( i=0; i<len; i++ )
      a[i] = MPIR_LBXOR(a[i],b[i]);
    break;
  }
  default:
    break;
  }
}



/* MINLOC and MAXLOC structures */
typedef struct {
  Int  value;
  Int  loc;
} MPIR_2int_loctype;

typedef struct {
  float  value;
  Int    loc;
} MPIR_floatint_loctype;

typedef struct {
  long  value;
  Int    loc;
} MPIR_longint_loctype;

typedef struct {
  short  value;
  Int    loc;
} MPIR_shortint_loctype;

typedef struct {
  double  value;
  Int     loc;
} MPIR_doubleint_loctype;

/* rs6000's assert STDC but do not implement long double. */
#if defined(__STDC__) && !defined(MPI_rs6000)
typedef struct {
  long double   value;
  Int           loc;
} MPIR_longdoubleint_loctype;
#endif


void MPIR_MAXLOC( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  if ((*type)->dte_type == MPIR_STRUCT) {
    /* Perform the operation based on the type of the first type in */
    /* struct */
    switch ((*type)->old_types[0]->dte_type) {
    case MPIR_INT: {
      MPIR_2int_loctype far *a = (MPIR_2int_loctype far *)inoutvec;
      MPIR_2int_loctype far *b = (MPIR_2int_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value < b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_FLOAT: {
      MPIR_floatint_loctype far *a = (MPIR_floatint_loctype far *)inoutvec;
      MPIR_floatint_loctype far *b = (MPIR_floatint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value < b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_LONG: {
      MPIR_longint_loctype far *a = (MPIR_longint_loctype far *)inoutvec;
      MPIR_longint_loctype far *b = (MPIR_longint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value < b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_SHORT: {
      MPIR_shortint_loctype far *a = (MPIR_shortint_loctype far *)inoutvec;
      MPIR_shortint_loctype far *b = (MPIR_shortint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value < b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_DOUBLE: {
      MPIR_doubleint_loctype far *a = (MPIR_doubleint_loctype far *)inoutvec;
      MPIR_doubleint_loctype far *b = (MPIR_doubleint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value < b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
/* rs6000's assert STDC but do not implement long double. */
#if defined(__STDC__) && !defined(MPI_rs6000)
    case MPIR_LONGDOUBLE: {
      MPIR_longdoubleint_loctype far *a = (MPIR_longdoubleint_loctype far *)inoutvec;
      MPIR_longdoubleint_loctype far *b = (MPIR_longdoubleint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value < b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
#endif
    default:
      MPIR_ERROR(MPI_COMM_WORLD, MPI_ERR_OP, 
                 "MAXLOC operation not supported on type");
    }
  }
  else {
    MPI_Datatype dtype = (*type)->old_type;
    len = len * (*type)->count;

    /* Perform the operation */
    switch (dtype->dte_type) {
    case MPIR_INT: {
      Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] < b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_LONG: {
      long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] < b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_SHORT: {
      short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] < b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_FLOAT: {
      float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] < b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_DOUBLE: {
      double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] < b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    default: 
      MPIR_ERROR(MPI_COMM_WORLD, MPI_ERR_OP, 
                 "MAXLOC operation not supported on type");
      break;
    }
  }
}


void MPIR_MINLOC( void far *invec, void far *inoutvec, Int far *Len, 
				MPI_Datatype far *type )
{
  Int i, len = *Len;

  if ((*type)->dte_type == MPIR_STRUCT) {
    /* Perform the operation based on the type of the first type in */
    /* struct */
    switch ((*type)->old_types[0]->dte_type) {
    case MPIR_INT: {
      MPIR_2int_loctype far *a = (MPIR_2int_loctype far *)inoutvec;
      MPIR_2int_loctype far *b = (MPIR_2int_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value > b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_FLOAT: {
      MPIR_floatint_loctype far *a = (MPIR_floatint_loctype far *)inoutvec;
      MPIR_floatint_loctype far *b = (MPIR_floatint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value > b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_LONG: {
      MPIR_longint_loctype far *a = (MPIR_longint_loctype far *)inoutvec;
      MPIR_longint_loctype far *b = (MPIR_longint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value > b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_SHORT: {
      MPIR_shortint_loctype far *a = (MPIR_shortint_loctype far *)inoutvec;
      MPIR_shortint_loctype far *b = (MPIR_shortint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value > b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
    case MPIR_DOUBLE: {
      MPIR_doubleint_loctype far *a = (MPIR_doubleint_loctype far *)inoutvec;
      MPIR_doubleint_loctype far *b = (MPIR_doubleint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value > b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
/* rs6000's assert STDC but do not implement long double. */
#if defined(__STDC__) && !defined(MPI_rs6000)
    case MPIR_LONGDOUBLE: {
      MPIR_longdoubleint_loctype far *a = (MPIR_longdoubleint_loctype far *)inoutvec;
      MPIR_longdoubleint_loctype far *b = (MPIR_longdoubleint_loctype far *)invec;
      for (i=0; i<len; i++) {
        if (a[i].value == b[i].value)
          a[i].loc = MPIR_MIN(a[i].loc,b[i].loc);
        else if (a[i].value > b[i].value) {
          a[i].value = b[i].value;
          a[i].loc   = b[i].loc;
        }
      }
      break;
    }
#endif
    default:
      MPIR_ERROR(MPI_COMM_WORLD, MPI_ERR_OP, 
                 "MINLOC operation not supported on type");
    }
  }
  else {

    /* Set the actual length */
    len = len * (*type)->count;

    /* Perform the operation */
    switch ((*type)->dte_type) {
    case MPIR_INT: {
      Int far *a = (Int far *)inoutvec; Int far *b = (Int far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] > b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_LONG: {
      long far *a = (long far *)inoutvec; long far *b = (long far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] > b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_SHORT: {
      short far *a = (short far *)inoutvec; short far *b = (short far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] > b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_FLOAT: {
      float far *a = (float far *)inoutvec; float far *b = (float far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] > b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    case MPIR_DOUBLE: {
      double far *a = (double far *)inoutvec; double far *b = (double far *)invec;
      for ( i=0; i<len; i+=2 ) {
        if (a[i] == b[i])
          a[i+1] = MPIR_MIN(a[i+1],b[i+1]);
        else if (a[i] > b[i]) {
          a[i]   = b[i];
          a[i+1] = b[i+1];
        }
      }
      break;
    }
    default: 
      MPIR_ERROR(MPI_COMM_WORLD, MPI_ERR_OP, 
                 "MINLOC operation not supported on type");
      break;
    }
  }
}
