/*
 *  $Id: gatherv.c,v 1.16 1994/06/07 21:29:46 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   gatherv.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: gatherv.c,v 1.16 1994/06/07 21:29:46 gropp Exp $";
#endif /* lint */

#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@

MPI_Gatherv - Gathers into specified locations from all processes in a group

Input Parameters:
. sendbuf - starting address of send buffer (choice) 
. sendcount - number of elements in send buffer (integer) 
. sendtype - data type of send buffer elements (handle) 
. recvcounts - integer array (of length group size) 
containing the number of elements that are received from each process
(significant only at root) 
. displs - integer array (of length group size). Entry 
 i  specifies the displacement relative to recvbuf  at
which to place the incoming data from process  i  (significant only
at root) 
. recvtype - data type of recv buffer elements 
(significant only at root) (handle) 
. root - rank of receiving process (integer) 
. comm - communicator (handle) 

Output Parameter:
. recvbuf - address of receive buffer (choice, significant only at root) 

@*/
Int MPI_Gatherv ( void far *sendbuf, Int sendcnt, MPI_Datatype sendtype, 
				  void far *recvbuf, Int far *recvcnts, Int far *displs,
				  MPI_Datatype recvtype, Int root, MPI_Comm comm)
{
//  MPI_Status status;
  Int        size, rank;
  Int        errno = MPI_SUCCESS;
  Int        flag;

  if ( MPIR_TEST_COMM(comm,comm) || MPIR_TEST_COUNT(comm,sendcnt) ||
       MPIR_TEST_DATATYPE(comm,sendtype)) 
    return MPIR_ERROR(comm, errno, "Error in MPI_GATHERV" );

  /* Check for intra-communicator */
  MPI_Comm_test_inter ( comm, &flag );
  if (flag) 
    return MPIR_ERROR(comm, MPI_ERR_COMM,
                      "Inter-communicator invalid in MPI_GATHERV");
  
  /* Is root within the communicator? */
  MPI_Comm_size ( comm, &size );
  if ( (root >= size) || (root < 0) )
    return MPIR_ERROR( comm, MPI_ERR_ROOT, "Invalid root in MPI_GATHERV" );

  /* Get my rank and switch communicators to the hidden collective */
  MPI_Comm_rank ( comm, &rank );
  comm = comm->comm_coll;

  /* Lock for collective operation */
  MPID_THREAD_LOCK(comm);

  /* If rank == root, then I recv lots, otherwise I send */
  if ( rank == root ) {
      MPI_Aint       extent;
      Int            i;
	MPI_Request req;
	MPI_Status       status;

    MPI_Isend(sendbuf, sendcnt, sendtype, root, MPIR_GATHERV_TAG, comm, &req);
    MPI_Type_extent(recvtype, &extent);
    for ( i=0; i<size; i++ ) {
      MPI_Recv( (void far *)((Int)recvbuf+displs[i]*extent), recvcnts[i], recvtype, i,
		 MPIR_GATHERV_TAG, comm, &status );
    }
	MPI_Wait(&req, &status);
  }
  else 
    MPI_Send( sendbuf, sendcnt, sendtype, root, MPIR_GATHERV_TAG, comm );

  /* Unlock for collective operation */
  MPID_THREAD_UNLOCK(comm);

  return (errno);
}

