/*
 *  $Id: alltoallv.c,v 1.15 1994/06/07 21:29:41 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*   altoalv.c                                                          *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: alltoallv.c,v 1.15 1994/06/07 21:29:41 gropp Exp $";
#endif /* lint */

#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@

MPI_Alltoallv - Sends data from all to all processes, with a displacement

Input Parameters:
. sendbuf - starting address of send buffer (choice) 
. sendcounts - integer array equal to the group size 
specifying the number of elements to send to each processor 
. sdispls - integer array (of length group size). Entry 
 j  specifies the displacement (relative to sendbuf  from
which to take the outgoing data destined for process  j  
. sendtype - data type of send buffer elements (handle) 
. recvcounts - integer array equal to the group size 
specifying the maximum number of elements that can be received from
each processor 
. rdispls - integer array (of length group size). Entry 
 i  specifies the displacement (relative to recvbuf  at
which to place the incoming data from process  i  
. recvtype - data type of receive buffer elements (handle) 
. comm - communicator (handle) 

Output Parameter:
. recvbuf - address of receive buffer (choice) 
@*/
Int MPI_Alltoallv ( void far *sendbuf, Int far *sendcnts, Int far *sdispls, 
					MPI_Datatype sendtype,
					void far *recvbuf, Int far *recvcnts, Int far *rdispls,
					MPI_Datatype recvtype, MPI_Comm comm)
{
  Int        size, rank, i;
  MPI_Aint   extent;
  Int        errno = MPI_SUCCESS;
  MPI_Status status;
  Int        flag;
  
  /* Check for invalid arguments */
  if ( MPIR_TEST_COMM(comm,comm) || MPIR_TEST_DATATYPE(comm,sendtype) ||
       MPIR_TEST_DATATYPE(comm,recvtype))
	return MPIR_ERROR(comm, errno, "Error in MPI_ALLTOALLV" ); 

  /* Check for intra-communicator */
  MPI_Comm_test_inter ( comm, &flag );
  if (flag) 
    return MPIR_ERROR(comm, MPI_ERR_COMM,
			  "Inter-communicator invalid in MPI_ALLTOALLV");
  
  /* Get size and rank and switch to collective communicator */
  MPI_Comm_size ( comm, &size );
  MPI_Comm_rank ( comm, &rank );
  comm = comm->comm_coll;

  /* Get extent of recvtype */
  MPI_Type_extent(recvtype, &extent);

  /* Lock for collective operation */
  MPID_THREAD_LOCK(comm);

  /* Send to all - receive from all */
  for ( i=0; i<size; i++ ) {
      MPI_Sendrecv ((void far *)((Int)sendbuf+sdispls[i]*extent), 
      				sendcnts[i], sendtype, i, MPIR_ALLTOALLV_TAG,
                    (void far *)((Int)recvbuf+rdispls[i]*extent), 
                    recvcnts[i], recvtype, i, MPIR_ALLTOALLV_TAG, 
		    		comm, &status );
  }

  /* Unlock for collective operation */
  MPID_THREAD_UNLOCK(comm);

  return (errno);
}
