/*
 *  $Id: alltoall.c,v 1.15 1994/06/07 21:29:40 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      All rights reserved.  See COPYRIGHT in top-level directory.
 */

/***********************************************************************
*                                                                      *
*                                                                      *
*   MPI for MS-Windows 3.1                                             *
*   current version: 0.99b          06/10/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is an MPI implementation for MS-Windows 3.1                   *
*   It is based on the MPI implementation from Argonne National        *
*   Laboratory and Mississippi State University, version from          *
*   June 17, 1994. Note their COPYRIGHT.                               *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/mpi )                         *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <mpiimpl.h>
#include <mpisys.h>
#pragma hdrstop

#ifndef lint
static char vcid[] = "$Id: alltoall.c,v 1.15 1994/06/07 21:29:40 gropp Exp $";
#endif /* lint */

#ifdef __BORLANDC__
/* BC cant find local header files - BUG ??? */
#include "..\src\coll\coll.h"
#else
#include "coll.h"
#endif /* __BORLANDC__ */

/*@

MPI_Alltoall - Sends data from all to all processes

Input Parameters:
. sendbuf - starting address of send buffer (choice) 
. sendcount - number of elements in send buffer (integer) 
. sendtype - data type of send buffer elements (handle) 
. recvcount - number of elements received from any process (integer) 
. recvtype - data type of receive buffer elements (handle) 
. comm - communicator (handle) 

Output Parameter:
. recvbuf - address of receive buffer (choice) 

@*/
Int MPI_Alltoall( 	void far *sendbuf, Int sendcount, MPI_Datatype sendtype,
					void far *recvbuf, Int recvcnt, MPI_Datatype recvtype, MPI_Comm comm)
{
  Int        size, rank, i;
  MPI_Aint   extent;
  Int        errno = MPI_SUCCESS;
  MPI_Status status;
  Int        flag;

  /* Check for invalid arguments */
  if ( MPIR_TEST_COMM(comm,comm) || MPIR_TEST_COUNT(comm,sendcount) ||
       MPIR_TEST_COUNT(comm,recvcnt) || MPIR_TEST_DATATYPE(comm,sendtype) ||
       MPIR_TEST_DATATYPE(comm,recvtype) )
	return MPIR_ERROR(comm, errno, "Error in MPI_ALLTOALL" ); 

  /* Check for intra-communicator */
  MPI_Comm_test_inter ( comm, &flag );
  if (flag) 
    return MPIR_ERROR(comm, MPI_ERR_COMM,
			  "Inter-communicator invalid in MPI_ALLTOALL");
  
  /* Get size and rank and switch to collective communicator */
  MPI_Comm_size ( comm, &size );
  MPI_Comm_rank ( comm, &rank );
  comm = comm->comm_coll;
  
  /* Get extent of recvtype */
  MPI_Type_extent ( recvtype, &extent );

  /* Lock for collective operation */
  MPID_THREAD_LOCK(comm);

  /* Send to all - receive from all */
  for ( i=0; i<size; i++ ) { 
	MPI_Sendrecv( (void far *)((Int)sendbuf+i*sendcount*extent), 
                 sendcount, sendtype, i, MPIR_ALLTOALL_TAG,
                 (void far *)((Int)recvbuf+i*recvcnt*extent), 
                 recvcnt, recvtype, i, MPIR_ALLTOALL_TAG,
                 comm, &status );
  }

  /* Unlock for collective operation */
  MPID_THREAD_UNLOCK(comm);

  return (errno);
}
