
/***********************************************************************
*                                                                      *
*   p4_winio.c                                                         *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

#include <windows.h>
/* #if defined(_WINDLL) && !defined(_FARARG_) && !defined(_VA_LIST_DEFINED) */
/* #pragma message ("va_list will be far ")                                 */
/* #endif                                                                   */
#include <stdarg.h>  // include before <stdio.h> to define va_list to be far
#include <stdio.h>   // really important - near va_list does not work
#include <string.h>
#include <ctype.h>
 
#include "p4.h"
#include "p4_sys.h" 

HWND		hwnd ;
static short	cxChar, cyChar;
char			exportbuf[512]; // for (char far *) to (char *)



static char 	P4_screen[P4SCRY][P4SCRX];
static short 	cxCursor, cyCursor;                    
// invalid regions of screen
static short 	cxMinScr, cxMaxScr, 
		cyMinScr, cyMaxScr;


void FAR PASCAL _export P4_ScrClear (HWND wnd)
{
	HDC		hdc ;
    TEXTMETRIC	tm;
    
    memset (P4_screen, (int)' ', sizeof (P4_screen));
    cxCursor = cyCursor = 0;
    
    hwnd = wnd;
    hdc = GetDC (hwnd); 
    GetTextMetrics (hdc, &tm);
    cxChar = tm.tmAveCharWidth;
    cyChar = tm.tmHeight + tm.tmExternalLeading;
    ReleaseDC (hwnd, hdc); 
}


void FAR PASCAL _export P4_SetCaretPos (void)
{
    SetCaretPos ((cxCursor+1) * cxChar, cyCursor * cyChar);
}


// add cursor position to invalid screen
static void P4ScrInvalidate (void)
{
    if (cxMinScr > cxCursor)
        cxMinScr = cxCursor;
    if (cxMaxScr <= cxCursor)
        cxMaxScr = cxCursor + 1;
        
    if (cyMinScr > cyCursor)
        cyMinScr = cyCursor;
    if (cyMaxScr <= cyCursor)
        cyMaxScr = cyCursor + 1;
}
                          
                          
static void P4ScrNewLine (void)
{
    cxCursor = 0; // begin of line
    if (++cyCursor < P4SCRY)
        return;
    // scroll
    cyCursor = P4SCRY - 1;
    memcpy (P4_screen[0], P4_screen[1], P4_screen[P4SCRY] - P4_screen[1]);
    memset (P4_screen[P4SCRY-1], (int)' ', P4SCRX);
    ScrollWindow (hwnd, 0, -cyChar, NULL, NULL);
    if (cyMinScr > 0) cyMinScr--;
}
                
static BOOL BkspSkipErase = FALSE;

static int P4_fputchar (int c)
{
    HideCaret (hwnd);
    switch (c)
    {
        case '\n' : 
            P4ScrNewLine ();
            break;
        case '\t' : // horizontal tab
            do
                P4_fputchar (' ');
            while (cxCursor % 8 != 0);   
            break;
        case '\r' : // carriage return
		    cxCursor = 0;
            break;
        case '\b' : // backspace
            if (BkspSkipErase == FALSE)
            {
			    if (cxCursor > 0)
			        cxCursor--;
			    else 
			    	if (cyCursor > 1)
			    	{
			    		cyCursor --;
			    		cxCursor = P4SCRX - 1;
			    	}
			    	
                BkspSkipErase == TRUE;
                P4_fputchar (' ');
            }
		    if (cxCursor > 0)
		        cxCursor--;
		    else 
		    	if (cyCursor > 1)
		    	{
		    		cyCursor --;
		    		cxCursor = 79;
		    	}
		    BkspSkipErase == FALSE;
		    break;
		case '\a' : // alert (bell)
			MessageBeep ((UINT)-1);             
			break;
		case '\f' : 
		case '\v' : 
		    break;
        default:
            if (!isprint (c)) // ignore \f, \v
                break;
        	P4_screen[cyCursor][cxCursor] = c;
        	P4ScrInvalidate ();
        	if (++cxCursor >= P4SCRX)
        	    P4ScrNewLine ();
    }

    SetCaretPos ((cxCursor+1) * cxChar, cyCursor * cyChar);
    ShowCaret (hwnd);
    return c;
}        

static P4BOOL first_protfile_open = TRUE;

// like puts but no newline at the end
int FAR PASCAL _export P4_Puts (const char far *string)
{
    char far *s;
    RECT	rc;
    FILE *	fp;
    
    // no invalid area                   
    cxMinScr = 80; 
    cxMaxScr = 0;
    cyMinScr = 25;
    cyMaxScr = 0;

    if ('\0' != bm_outfile[0]) /* write protocol file */
    {
        if (first_protfile_open)
        {
            first_protfile_open = FALSE;
            fp = fopen (bm_outfile, "w");
        }
        else
            fp = fopen (bm_outfile, "a");
            
        if (NULL == fp)
            p4_error ("Open master output file failed", 0);
        
	   	s = (char far *)string;
	    while ('\0' != *s)
	    {
	        putc (*s, fp);	/* macro */
	        s++;
	    }
	    fclose (fp);
	}
        
   	s = (char far *)string;
    while ('\0' != *s)
        P4_fputchar (*(s++));

    rc.left   = (cxMinScr+1) * cxChar;
    rc.top    = cyMinScr * cyChar;
    rc. right = (cxMaxScr+1) * cxChar;
    rc.bottom = cyMaxScr * cyChar; 
    InvalidateRect (hwnd, &rc, TRUE);
    
    return (1); // always successful
}
   

int puts (const char far *string)
{
    char far *s = (char far *)string;
    
    while ('\0' != *s)
        P4_fputchar (*(s++));
    P4_fputchar ('\n');
    return (1); // always successful
}

                           
int vprintf (const char *fmt, va_list ap)
{   
    static char pBuf[512];
    int		ret;
                   
   // God bless the inventor of that function !!!
    ret = _vsnprintf (pBuf, 511, fmt, ap);
    
    // print expanded string on my MPI screen
    pBuf[511] = '\0';
    P4_Puts (pBuf);
    
    return ret;
} 


int printf (const char *fmt, ...)
{   
	static char PArgBuf[64]; /* not string, but argument buffer ! */
	va_list	ap;
    int ret;
    
//  #define va_start(ap,v) ap = (va_list)&v + _INTSIZEOF(v)
    va_start (ap, fmt);

/*  1.)  _vsnprintf() and, hence, vprintf() expect a near pointer to the argument list as 
 *	second parameter. Using printf(), this list is stored on the stack.  But vprintf()
 *	relates the pointer to the data segment (while interpreting fmt as pointer to the
 *	stack segment !)  Therefore, we have to copy the arguments from the stack to a 
 *	data segment buffer which stores only numbers and pointers to strings. Argument lists
 *	are hardly ever longer than 64 bytes.  
 *  2.)  Pointers to strings (and all other types, too) are assumed to refer to the data
 *	segment. NEVER EVER print stack data (strings, arrays) using pointers !!!!!!
 */
    _fmemcpy (PArgBuf, ap, sizeof(PArgBuf) - 1);
    PArgBuf[sizeof(PArgBuf - 1)] = '\0';
    
    ret = vprintf (fmt, PArgBuf);
    va_end (fmt); 
    
    return ret;
}


BOOL FAR PASCAL _export P4_TextOut (HDC hdc, int nY, int nXStart, int nXLen)
{   
     return (TextOut (hdc, (nXStart + 1) * cxChar, 
   			nY * cyChar, P4_screen[nY] + nXStart, nXLen));
}

