
/***********************************************************************
*                                                                      *
*   p4_sys_f.h                                                         *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

P4VOID 	alloc_global(void);
struct local_data *	alloc_local_bm(void);
struct local_data *	alloc_local_slave(void); 
struct p4_msg far *	alloc_p4_msg(Int msglen);
struct p4_procgroup far *	alloc_procgroup(void);
struct p4_queued_msg far *	alloc_quel (void);
int	bm_start(int far *argc, LPPSTR argv);
Int 	create_bm_processes (struct p4_procgroup far *pg);
P4VOID 	create_one_remote(struct p4_procgroup_entry *pe, char *outfile, Int rm_num);
Int 	create_remote_processes();
P4VOID 	create_rm_processes(Int nslaves, Int bm_fd);
Int 	data_representation(char far *machine_type);
P4VOID 	dump_conntab(Int level);
P4VOID 	dump_global(Int level);
P4VOID 	dump_local(Int level);
P4VOID 	dump_procgroup(struct p4_procgroup far *procgroup, Int level);
P4VOID 	dump_tmsg(struct p4_msg far *tmsg);
P4VOID 	free_p4_msg(struct p4_msg far *tmsg);
P4VOID 	free_quel(struct p4_queued_msg far *q);
struct local_data * get_my_p4_local (void);
P4VOID 	get_qualified_hostname (char far *str); 
struct p4_msg far *	get_tmsg(Int type, Int from, Int to, char far *msg, Int len, 
				Int data_type, P4BOOL ack_req, P4BOOL p4_buff_ind);
P4BOOL 	in_same_cluster(Int i, Int j);
P4VOID 	init_avail_buffs(void);
P4VOID 	initialize_msg_queue(struct p4_msg_queue far *mq);
Int 	install_in_proctable(Int, Int, char far *, char far *);
P4VOID 	MD_initenv(void);
P4VOID 	MD_initmem(unsigned long memsize);
P4VOID 	MD_shfree(char far *ptr);
char far *	MD_shmalloc (unsigned long size);
int 	my_fatoi (char far *string);
Int 	num_in_mon_queue (p4_monitor_t far *m, Int i);
char *	print_conn_type(Int conn_type);
P4VOID 	process_args(int far *argc, LPPSTR argv);
P4VOID 	procgroup_to_proctable(struct p4_procgroup far *pg);
P4VOID 	queue_p4_message(struct p4_msg far *msg, struct p4_msg_queue far *hdr);
struct p4_procgroup far *	read_procgroup(void);
struct p4_msg far *		recv_message(Int far *req_type, Int far *req_from);
struct p4_msg far *		search_p4_queue(Int req_type, Int req_from, P4BOOL deq);
P4VOID 	setup_conntab(void);
P4BOOL 	shmem_msgs_available(void);
struct p4_msg far *	shmem_recv(void);
Int 	shmem_send(struct p4_msg far *tmsg);
int 	slave_start(int far *argc, LPPSTR argv);
Int 	subtree_broadcast_p4(Int type, Int from, char far *data, Int , Int);
P4VOID	usc_init();
P4VOID 	xx_init_shmalloc (LPSTR memory, unsigned long nbytes);
P4VOID 	xx_shfree(char far *);
char far *	xx_shmalloc(unsigned long nbytes);

struct local_data * 	FAR PASCAL _export get_new_p4_local (void);
P4VOID	FAR PASCAL _export p4_set_dbg_level_dll(Int level);
Int	FAR PASCAL _export MD_clock(void);

void	FAR PASCAL _export P4_ScrClear (HWND wnd);
void	FAR PASCAL _export P4_SetCaretPos (void);
BOOL	FAR PASCAL _export P4_TextOut (HDC hdc, int nY, int nXStart, int nXLen);
P4VOID	FAR PASCAL _export zap_p4_processes(void);


