
/***********************************************************************
*                                                                      *
*   p4_md.h                                                            *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/

/* ------------------ Machine Dependent Definitions ---------------- */
/*
        It is important to maintain the order of many of the 
        definitions in this file.
*/
#ifdef WIN31		// MSVC does not offer a switch: compile with 4byte int's
#ifndef Int 
#define Int long	// hope that does not cause too much trouble 
#endif
#endif  

#define P4BOOL int
#define P4VOID void

#include <sys/timeb.h>
#define GLOBMEMSIZE  ((long)512*1024)

// queue per proc in cluster - in WIN31 all procs in one cluster
#define P4_MAX_MSG_QUEUES P4_MAXPROCS  
typedef Int p4_lock_t;

typedef unsigned long p4_usc_time_t;

#define P4_MAXPROCS 	16
#define P4_MAXCLUSTER	4 	/* determines # procgroups, too */

#define HOSTNAME_LEN 	64

#define p4_malloc malloc
#define p4_free free
