
/***********************************************************************
*                                                                      *
*   p4_funcs.h                                                         *
*   p4 1.4 for MS-Windows 3.1                                          *
*   current version: 0.99b          07/16/95                           *
*                                                                      *
*   Joerg Meyer                                                        *
*   University of Nebraska at Omaha (UNO)                              *
*   Department of Computer Science                                     *
*                                                                      *
*   This is the WIN31 version of the p4 Parallel Programming System    *
*   developed at Argonne National Laboratory.  Note their COPYRIGHT.   *
*   ( source code and user's guide available by anonymous FTP from     *
*     info.mcs.anl.gov in directory /pub/p4 )                          *
*   Anyone is free to copy and modify this code to suit his or her     *
*   own purposes as long as these notices are retained.                *
*                                                                      *
***********************************************************************/


typedef P4VOID FAR PASCAL _export FPF(char far*, char far*, Int);
typedef FPF (*PFPF);
 
P4VOID	FAR PASCAL _export P4WinMessageLoop(void);
P4VOID		FAR PASCAL _export P4WinSetPkgName (char far *);

struct p4_procgroup far * FAR PASCAL _export p4_alloc_procgroup(void);
P4BOOL	FAR PASCAL _export p4_am_i_cluster_master(void);
P4BOOL	FAR PASCAL _export p4_any_messages_available(void);
Int	FAR PASCAL _export p4_askfor (p4_askfor_monitor_t far *, Int, Int (far *getprob_fxn) (), 
												  P4VOID far *, P4VOID (far *reset_fxn) ());
P4VOID	FAR PASCAL _export p4_barrier (p4_barrier_monitor_t far *b, Int nprocs);
Int	FAR PASCAL _export p4_barrier_init(p4_barrier_monitor_t far *b);
Int	FAR PASCAL _export p4_broadcastx(Int type, char far *data, Int data_len, Int data_type);
Int	FAR PASCAL _export p4_clock(void);
P4VOID	FAR PASCAL _export p4_cluster_shmem_sync (LPSTR far *cluster_shmem);
Int	FAR PASCAL _export p4_create(Int (far *fxn) ());
Int	FAR PASCAL _export p4_create_procgroup(void);
P4VOID	FAR PASCAL _export p4_dbl_absmax_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_dbl_absmin_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_dbl_max_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_dbl_min_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_dbl_mult_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_dbl_sum_op(char far *x, char far *y, Int nelem);
P4VOID					   p4_dprintf(char *fmt, ...);
P4VOID	FAR PASCAL _export p4_error(char far *string, Int value);
P4VOID	FAR PASCAL _export p4_flt_absmax_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_flt_absmin_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_flt_max_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_flt_min_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_flt_mult_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_flt_sum_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_get_cluster_masters(Int far *numids, Int far ids[]);
P4VOID	FAR PASCAL _export p4_get_cluster_ids(Int far *start, Int far *end);
Int			   p4_get_dbg_level(void);
Int	FAR PASCAL _export p4_get_my_cluster_id(void);
Int	FAR PASCAL _export p4_get_my_id(void);
Int	FAR PASCAL _export p4_getsub_init(p4_getsub_monitor_t far *gs);
P4VOID	FAR PASCAL _export p4_getsubs(p4_getsub_monitor_t far *gs, 
					  Int far *s, Int max, Int nprocs, Int stride);
P4VOID	FAR PASCAL _export p4_global_barrier(Int type);
Int	FAR PASCAL _export p4_global_op (Int type, char far *x, Int nelem, Int size, 
					 FPF (*op), Int data_type);
int	FAR PASCAL _export p4_initenv(int far *argc, LPPSTR argv);
P4VOID	FAR PASCAL _export p4_int_absmax_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_int_absmin_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_int_max_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_int_min_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_int_mult_op(char far *x, char far *y, Int nelem);
P4VOID	FAR PASCAL _export p4_int_sum_op(char far *x, char far *y, Int nelem);
P4VOID  FAR PASCAL _export p4_lock_init (p4_lock_t far *l);
P4VOID  FAR PASCAL _export p4_lock (p4_lock_t far *l);
P4VOID	FAR PASCAL _export p4_mcontinue(p4_monitor_t far *m, Int i);
P4VOID	FAR PASCAL _export p4_mdelay(p4_monitor_t far *m, Int i);
P4VOID	FAR PASCAL _export p4_menter(p4_monitor_t far *m);
P4BOOL	FAR PASCAL _export p4_messages_available(Int far *req_type, Int far *req_from);
P4VOID	FAR PASCAL _export p4_mexit(p4_monitor_t far *m);
Int	FAR PASCAL _export p4_moninit(p4_monitor_t far *m, Int i);
char far *	FAR PASCAL _export p4_msg_alloc(Int msglen);
P4VOID	FAR PASCAL _export p4_msg_free(char far *m);
Int	FAR PASCAL _export p4_num_cluster_ids(void);
Int	FAR PASCAL _export p4_num_total_ids(void);
Int	FAR PASCAL _export p4_num_total_slaves(void);
P4VOID	FAR PASCAL _export p4_print_avail_buffs(void);
P4VOID	FAR PASCAL _export p4_probend(p4_askfor_monitor_t far *af, Int code);
P4VOID	FAR PASCAL _export p4_progend(p4_askfor_monitor_t far *af);
Int	FAR PASCAL _export p4_recv (Int far *req_type, Int far *req_from, 
					LPPSTR msg, Int far *len_rcvd);
Int 	FAR PASCAL _export send_message (Int type, Int from, Int to, 
					 char far *msg, Int len, Int data_type, 
					 P4BOOL ack_req, P4BOOL p4_buff_ind);
P4VOID			   p4_set_dbg_level(Int level);
P4VOID	FAR PASCAL _export p4_shfree(void far *p);
char far *	FAR PASCAL _export p4_shmalloc(unsigned long n);
Int	FAR PASCAL _export p4_soft_errors(Int onoff);
Int	FAR PASCAL _export p4_startup(struct p4_procgroup far *pg);
P4VOID  FAR PASCAL _export p4_unlock (p4_lock_t far *l);
P4VOID	FAR PASCAL _export p4_update(p4_askfor_monitor_t far *af, 
					Int (far *putprob_fxn) (), P4VOID far *problem);
p4_usc_time_t FAR PASCAL _export p4_usrollover(void);
p4_usc_time_t FAR PASCAL _export p4_ustimer(void);
char far *	FAR PASCAL _export p4_version(void);
void	FAR PASCAL _export p4_wait_for_end(void);

#ifdef P4_DPRINTFL
P4VOID			   p4_dprintfl (Int level, char *fmt, ...);
#endif     

#ifdef WIN31
int _fputchar (int c);
#ifdef _WINDLL
int puts (const char far *string);
int vprintf (const char *fmt, va_list);
#else
#ifdef __BORLANDC__
int _Cdecl puts (const char *string);
#else
int puts (const char *string);
#endif /* __BORLANDC__ */
#endif /* _WINDLL */
int printf (const char *fmt, ...);
int	FAR PASCAL _export P4_Puts (const char far *string);

#endif /* WIN31 */
